 {
 ***********************************************************************
 Daq Pascal application program uniheater_pulser.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 ***********************************************************************
 Программа генерации меандра (meander pulser) для подсистемы UniHeater
 управления унифицированными нагревателями (печами) (Unified Heaters).
 Конфигурирование и описание (здесь i=[1..32] - номер нагревателя):
 1)  Имя устройства имеет вид &XXXX.UNIHEATER.PULSER, где XXXX-общее имя
     подсистемы UniHeater, например, DEMO или TEST.UH (точки допустимы).
 2)  Все имена тегов и кривых имеют вид XXXX.UNIHEATER.PPP, который
     имеет тот же префикс XXXX.UNIHEATER и берется из имени устройства.
     Здесь PPP - имя конкретного параметра, например QX_i,GATE_i и т.д.
 3)  К входам AnalogInput(1..32) подключаются каналы скважностей печей.
     Скважности (точнее сказать, коэффициенты заполнения) QX_i задаются
     в процентах, в диапазоне от 0 до 100%.
 4)  На выходы DigitalOutput(1..32) выдаются сигналы управления GATE_i,
     которые подаются на твердотельные реле для включения нагревателей.
     Сигнал управления - меандр с заданной скважностью (коэффициентом
     заполнения в процентах) QX_i и периодом PERIOD_i (в секундах).
 5)  Число каналов нагревателей определяется по максимальному номеру
     подключенной кривой DigitalOutput.
 6)  Нулевые каналы для рабочих нагревателей не используются!
     Нулевые каналы используются только для редактирования параметров! 
 7)  Период меандра задается (в миллисекундах) в теге PERIOD_i.
 ***********************************************************************
 20211215 Alexey Kuryakin
 ***********************************************************************
 }
program uniheater_pulser;        { UniHeater pulse generator        }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxHeater       = 32;           { Maximal number of heaters        }
 MaxCycle        = 100;          { Maximal number of cycles to reset}

type   { N.B. Fake Heater[0] uses just for settings editing only!  }
 THeaterTags     = array [0..MaxHeater] of Integer; { Array of Tags }
 THeaterVals     = array [0..MaxHeater] of Real;    { & data Values }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 NumHeaters      : Integer;      { Current number of heaters        }
 tStart          : THeaterVals;  { Time of start                    }
 tagGATE         : THeaterTags;  { Gate signal                      }
 typGATE         : THeaterTags;  { Typeof Gate                      }
 tagPERIOD       : THeaterTags;  { Pulser Period, ms                }
 typPERIOD       : THeaterTags;  { Typeof Period                    }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Get tag prefix by device name (drop head & and tail .PULSER).
 }
 function tagPrefix:String;
 begin
  tagPrefix:=ExtractFileName(Copy(DevName,2));
 end;
 {
 Get UniHeater full tag name with prefix.
 }
 function UniTagName(Name:String; i:Integer):String;
 begin
  if (i>0) then Name:=Name+Str(i);
  Name:=tagPrefix+'.'+Name;
  UniTagName:=Name;
 end;
 {
 Clear Pulser...
 }
 procedure Pulser_Clear;
 var i:Integer;
 begin
  for i:=1 to MaxHeater do tStart[i]:=0;
  for i:=1 to MaxHeater do tagGATE[i]:=0;
  for i:=1 to MaxHeater do typGATE[i]:=0;
  for i:=1 to MaxHeater do tagPERIOD[i]:=0;
  for i:=1 to MaxHeater do typPERIOD[i]:=0;
 end;
 {
 Initialize Pulser...
 }
 procedure Pulser_Init;
 var i,n:Integer;
 begin
  {
  Find number of heaters by max. number of connected DO's
  Find UniHeater Gate tags and prefix by DO's curve name
  }
  NumHeaters:=0;
  n:=imin(MaxHeater,NumDOs);
  for i:=1 to n do if (RefDo(i)<>_Nil) then begin
   tagPERIOD[i]:=FindTag(UniTagName('PERIOD_',i));
   tagGATE[i]:=FindTag(CrvName(RefDo(i)));
   typPERIOD[i]:=TypeTag(tagPERIOD[i]);
   typGATE[i]:=TypeTag(tagGATE[i]);
   NumHeaters:=i;
  end;
  Success('tagPrefix  = '+tagPrefix);
  Success('NumHeaters = '+Str(NumHeaters));
  for i:=1 to NumHeaters do begin
   if (typGATE[i]=1) then Success(StrFmt('%-10s','Gate_'+Str(i))+' = integer '+Str(iGetTag(tagGATE[i]))) else
   if (typGATE[i]=2) then Success(StrFmt('%-10s','Gate_'+Str(i))+' = real    '+Str(rGetTag(tagGATE[i])));
  end;
  for i:=1 to NumHeaters do begin
   if (typPERIOD[i]=1) then Success(StrFmt('%-10s','Period_'+Str(i))+' = integer '+Str(iGetTag(tagPERIOD[i]))) else
   if (typPERIOD[i]=2) then Success(StrFmt('%-10s','Period_'+Str(i))+' = real    '+Str(rGetTag(tagPERIOD[i])));
  end;
  {
  Initialize timers...
  }
  for i:=1 to NumHeaters do begin
   tStart[i]:=mSecNow-Int(rGetTag(tagPERIOD[i])*(i-1)/Max(1,NumHeaters-1));
  end;
 end;
 {
 Finalize Pulser...
 }
 procedure Pulser_Free;
 begin
 end;
 {
 Poll Pulser...
 }
 procedure Pulser_Poll;
 var i,gate:Integer; qp,qx,dt,Period:Real; b:Boolean;
 begin
  {
  Calculate meander for all heaters
  }
  for i:=1 to NumHeaters do begin                                   // For all heaters
   if (RefDo(i)<>_Nil) then begin                                   // If DO connected
    Period:=0; dt:=0; qp:=0; qx:=0;                                 // Initialize variables
    if (typPERIOD[i]=1) then Period:=iGetTag(tagPERIOD[i]) else     // Get pulse period, ms
    if (typPERIOD[i]=2) then Period:=rGetTag(tagPERIOD[i]);         // Get pulse period, ms
    if (Period>0) then dt:=Max(0.0,(mSecNow-tStart[i])/Period);     // Time since tStart, in period units
    qp:=Max(0.0,Min(100.0,GetAi_Yn(i)));                            // Get off-duty factor in 0..100% range
    qx:=Max(0.0,Min(1.0,qp*0.01));                                  // Get off-duty factor in 0..1 range
    if IsNan(dt) or IsInf(dt) then dt:=0;                           // Avoid NAN, INF
    if IsNan(qx) or IsInf(qx) then qx:=0;                           // Avoid NAN, INF
    gate:=Ord((qx>0) and (frac(dt)<=qx));                           // Gate signal, i.e. ON/OFF=1/0
    if (typGATE[i]=1) then b:=iSetTag(tagGATE[i],gate) else         // Update GATE tag
    if (typGATE[i]=2) then b:=rSetTag(tagGATE[i],gate);             // Update GATE tag
    b:=PutDo(i,time,gate);                                          // Enpack pulser (meander) event
    if (Int(dt)>MaxCycle) then tStart[i]:=tStart[i]+Int(dt)*Period; // Update tStart to avoid rounding errors
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  Pulser_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  Pulser_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  Pulser_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  Pulser_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
