 {
 Standard routines for Utils:
 procedure WebBrowser(FileName:String);
 function  RmtShareExe(Share,Local,Options:String; TimeOut:Integer):Boolean;
 procedure UnixWBox(Title,Message:String; WW,FS,TM:Integer);
 procedure UnixTooltipNotifier(args:String);
 procedure ShowTooltip(args:String);
 procedure StdSensorHelpTooltip(Msg:String; Delay:Integer);
 function  CustomIniRW(RW:Char; arg:String; mode:Integer):Integer;
 function  WinListByCurve(crv:Integer; comma:Char):String;
 function  WinSelectByCurve(crv:Integer; selcrv:Integer):Integer;
 function  DeviceListEnum(n:Integer):Integer;
 function  CalibrOpenByCurve(crv:Integer):Boolean;
 procedure ClearStdUtils;
 procedure InitStdUtils;
 procedure FreeStdUtils;
 procedure PollStdUtils;
 }
 {
 Call HTML browser.
 }
 procedure WebBrowser(FileName:String);
 var WebViewer:String; p:Integer;
 begin
  FileName:=Trim(FileName);
  if Length(FileName)=0 then FileName:='http://localhost/';
  WebViewer:=ParamStr('GetExeByFile '+DaqFileRef('~~\Resource\Manual\crw-daq.htm',''));
  if FileExists(WebViewer) then begin
   p:=task_init('"'+WebViewer+'" "'+FileName+'"');
   if task_run(p)
   then Success('Start pid '+Str(task_pid(p))+': '+task_ctrl(p,'CmdLine'))
   else Success('Could not browse '+FileName);
   bNul(task_Free(p));
  end else begin
   if ShellExecute('open|'+FileName)<=32 then Success('Could not open '+FileName);
  end;
  WebViewer:='';
 end;
 {
 Share directory in network using RmtShare.exe.
 Example:
  @run RmtShare \\server\test /DELETE
  @run RmtShare \\server\test=e:\test /GRANT Все:Read /REMARK:"Test share"
  RtmShareExe('\\server\test','e:\test','/GRANT Все:READ'
                       +' /GRANT Администраторы:"FULL CONTROL"'
                       +' /GRANT "Опытные пользователи":CHANGE'
                       +' /REMARK:"Test share"');
  RtmShareExe('\\server\test','','/DELETE');
 }
 function RmtShareExe(Share,Local,Options:String; TimeOut:Integer):Boolean;
 var pid,err:Integer; Cmd,Log:String; fs,ms:Real;
 begin
  RmtShareExe:=False;
  Share:=Trim(Share);
  Local:=Trim(Local);
  Options:=Trim(Options);
  if (Length(Share)>0) and (Pos('\\',Share)<>1)
  then Share:='\\'+ParamStr('ComputerName')+'\'+Trim(ExtractFileName(Share));
  Log:=AddBackSlash(ParamStr('TempPath'))+'RmtShare.Log';
  Cmd:=ParamStr('FileSearch RmtShare.Exe');
  if FileExists(Cmd) then begin
   Cmd:=GetComSpec+' /c '+Cmd;
   if Length(Share)>0 then begin
    Cmd:=Cmd+' '+Share;
    if Length(Local)>0 then Cmd:=Cmd+'='+Local;
   end;
   if Length(Options)>0 then Cmd:=Cmd+' '+Options;
   Cmd:=Cmd+' >> '+Log;
   fs:=0;
   if FileExists(Log) then begin
    if f_Reset(Log,1)=0 then fs:=f_Size;
    bNul(f_Close);
   end;
   if fs>2*1024*1024 then bNul(FileErase(Log));
   if FileExists(Log) then err:=Append(Log) else err:=Rewrite(Log);
   if err=0 then Writeln(GetDateTime(mSecNow),EOL,Cmd);
   err:=Append('');
   pid:=Task_Init(Cmd);
   sNul(Task_Ctrl(pid,'Display=0'));
   if Task_Run(pid) then begin
    ms:=mSecNow;
    while mSecNow<ms+TimeOut do
    if Task_Wait(pid,10) then bNul(wdt_Reset(True)>0) else ms:=0;
    RmtShareExe:=not Task_Wait(pid,0);
   end;
   bNul(Task_Free(pid));
  end;
  Log:='';
  Cmd:='';
 end;
 {
 Call warning box with specified title, message, window width, font size, timeout.
 }
 procedure UnixWBox(Title,Message:String; WW,FS,TM:Integer);
 begin
  if not IsEmptyStr(Title) then
  if not IsEmptyStr(Message) then begin
   Message:=StrReplace(Message,EOL,'^^',3);
   rNul(Eval('@system @async @silent @run -hide -lower unix wbox '
        +StrAddQuotes(Title,'"')+' '+StrAddQuotes(Message,'"')+' Ok '
        +' /WW='+Str(WW)+' /FS='+Str(FS)+' /TM='+Str(TM)));
  end;
 end;
 {
 Call tooltip notifier with specified text, font, fontSize, delay, bkColor, textColor, ico, audio.
 Example: UnixTooltipNotifier('text "Demo text" font "PT Mono Bold" fontSize 14 delay 15000'
                            +' bkColor red ico notify.ico audio notify.wav');
 arguments are:
  text "Demo text"             - quoted text to print
  font "PT Mono Bold"          - font family name
  fontSize 16                  - font size, pt
  delay 15000                  - hide message after delay, ms
  bkColor red                  - background color, 0xRRGGBB or (red,blue,green,white,black,...)
  textColor 0xFF0000           - text RGB color, hexadecimal, 0xRRGGBB
  trans 255                    - transparency, 0..255
  ico notify.ico               - icon file name (exe,dll,ico)
  audio notify.wav             - play sound (wav)
 }
 procedure UnixTooltipNotifier(args:String);
 begin
  if not IsEmptyStr(args) then
  rNul(Eval('@system @async @silent @run -hide -lower unix tooltip-notifier '+Trim(args)));
 end;
 procedure ShowTooltip(args:String);
 begin
  if not IsEmptyStr(args) then rNul(Eval('@system @async @silent @tooltip '+Trim(args)));
 end;
 {
 Procedure to show standard sensor help tooltip, usually on right click.
 }
 procedure StdSensorHelpTooltip(Msg:String; Delay:Integer);
 begin
  if Length(Msg)>0 then begin
   ShowTooltip('guid '+Str(GetPid)+'@'+ProgName+' text "'+Msg+'" preset stdHelp delay '+Str(Delay)
              +' btn1 Справка cmd1 "'+IfThenStr(IsWindows,'cmd /c start ','')
              +DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm')+'"');
  end;
 end;
 {
 Save/Load a custom parameters to/from INI file.
 RW   -> Operation mode: RW=W,O,S=Write/Output/Save or RW=R,I,L=Read/Input/Load.
 arg  -> 0..4 words with INI file name, custom parameters section, tag list section name
 mode ->  mode bit flags: bit0=NoEcho, bit1=NoWBox, bit2=NoDateCopy, bit3=NoCopy
 Example:
 arg = ..\Config\Custom.ini        [CustomParameters]          [CustomParameters.TagList]  ..\Data\Custom
 If empty arg specified, use ReadIni variables from device section:
 arg = ReadIni('CustomIniFileRef') ReadIni('CustomIniSection') ReadIni('CustomIniTagList') ReadIni('CustomIniBackups')
 [&DeviceSection]
 CustomIniFileRef = ..\Config\Custom.ini
 CustomIniSection = [CustomParameters]
 CustomIniTagList = [CustomParameters.TagList]
 CustomIniBackups = ..\Data\Custom
 [CustomParameters.TagList]
 TagList = tag1,tag2,tag3,tag4
 TagList = tag5,tag6,tag7,...
 [CustomParameters]
 tag1=1235
 tag2=5.67
 tag3=abcd
 []
 Example:
 iNul(CustomIniRW('W','',0));
 iNul(CustomIniRW('R','..\Config\Custom.ini [CustomParameters] [CustomParameters.TagList] ..\Data\Custom',0));
 }
 function CustomIniRW(RW:Char; arg:String; mode:Integer):Integer;
 var i,m,n,nrw,txt,tag:Integer; cif,cis,ctl,bkp,bk1,bk2:String;
  procedure AddTag(txt,tag:Integer);
  var i,n:Integer; match:String;
  begin
   if TypeTag(tag)>0 then begin
    n:=0; match:=NameTag(tag);
    for i:=0 to Text_NumLn(txt)-1 do
    if IsSameText(Text_GetLn(txt,i),match) then n:=n+1;
    if n=0 then bNul(Text_Addln(txt,match));
   end;
   match:='';
  end;
  function LoadTagValues(sec,txt:Integer):Integer;
  var i,p:Integer;
  begin
   LoadTagValues:=sec;
   for i:=0 to Text_NumLn(sec)-1 do begin
    p:=Pos('=',Text_GetLn(sec,i));
    if p>0 then begin
     tag:=FindTag(Trim(Copy(Text_GetLn(sec,i),1,p-1)));
     if TypeTag(tag)>0 then begin
      UpdateTag(tag,Trim(Copy(Text_GetLn(sec,i),p+1)),_MinusInf,_PlusInf);
      AddTag(txt,tag);
     end;
    end;
   end;
  end;
  function LoadTagNames(sec,txt:Integer):Integer;
  var i:Integer;
  begin
   LoadTagNames:=sec;
   for i:=0 to Text_NumLn(sec)-1 do AddTag(txt,FindTag(ExtractWord(1,Text_GetLn(sec,i))));
  end;
  function LoadTagList(sec,txt:Integer):Integer;
  var i,j:Integer;
  begin
   LoadTagList:=sec;
   for i:=0 to Text_NumLn(sec)-1 do
   if IsSameText(ExtractWord(1,Text_GetLn(sec,i)),'TagList') then
   for j:=2 to WordCount(Text_GetLn(sec,i)) do AddTag(txt,FindTag(ExtractWord(j,Text_GetLn(sec,i))));
  end;
  procedure Report(n:Integer; msg:String);
  begin
   if not IsEmptyStr(msg) then begin
    if n=0 then Success(msg) else Problem(msg);
    if not IsBit(mode,0) then bNul(Echo(DevName+' : '+GetDateTime(mSecNow)+EOL+DevName+' : '+msg));
    if not Starting then if not Stopping then if not IsBit(mode,1) then
    //UnixWBox(ExtractWord(1,msg)+' report',msg,600,14,15);
    ShowTooltip('guid '+Str(getpid)+'@'+ExtractWord(1,msg)
              +' text "'+GetDateTime(mSecNow)+' - '+ParamStr('SessionName')+': '+msg+'"'
              +' preset '+ExtractWord(1+Ord(n>0),'stdSuccess,stdError')
              +' delay '+ExtractWord(1+Ord(n>0),'15000,86400000'));
   end;
  end;
 begin
  cif:='';
  cis:='';
  ctl:='';
  bkp:='';
  bk1:='';
  bk2:='';
  nrw:=0;
  cif:=ExtractWord(1,arg);
  cis:=ExtractWord(2,arg);
  ctl:=ExtractWord(3,arg);
  bkp:=ExtractWord(4,arg);
  if IsEmptyStr(cif) then cif:=AdaptFileName(ReadIni('CustomIniFileRef'));
  if IsEmptyStr(cis) then cis:=Trim(ReadIni('CustomIniSection'));
  if IsEmptyStr(ctl) then ctl:=Trim(ReadIni('CustomIniTagList'));
  if IsEmptyStr(bkp) then bkp:=AdaptFileName(ReadIni('CustomIniBackups'));
  if not IsEmptyStr(cis) then cis:=StrAddBrackets(cis,'[',']');
  if not IsEmptyStr(ctl) then ctl:=StrAddBrackets(ctl,'[',']');
  if not IsEmptyStr(cif) then cif:=DaqFileRef(cif,'.ini');
  if not IsEmptyStr(bkp) then bkp:=DaqFileRef(bkp,'');
  if Pos(UpCaseStr(RW),'WOS>')>0 then begin
   n:=0; m:=0;
   if not IsEmptyStr(cis) then
   if not IsEmptyStr(cif) then
   if not DirExists(ExtractFilePath(cif)) then bNul(MkDir(ExtractFilePath(cif)));
   if not IsEmptyStr(cis) then
   if not IsEmptyStr(cif) then
   if DirExists(ExtractFilePath(cif)) then begin
    txt:=Text_New;
    bNul(Text_Free(LoadTagNames(ReadIniSection(Text_New,28,'',cis),txt)));
    bNul(Text_Free(LoadTagNames(ReadIniSection(Text_New,28,cif,cis),txt)));
    if not IsEmptyStr(ctl) then
    bNul(Text_Free(LoadTagList(ReadIniSection(Text_New,28,'',ctl),txt)));
    for i:=0 to Text_NumLn(txt)-1 do begin
     tag:=FindTag(Trim(Text_GetLn(txt,i)));
     if TypeTag(tag)>0 then bNul(Text_PutLn(txt,i,NameTag(tag)+' = '+TagAsText(tag)));
    end;
    bNul(Text_InsLn(txt,0,'; Saved '+GetDateTime(mSecNow)));
    bNul(Text_InsLn(txt,0,cis));
    bNul(Text_AddLn(txt,'[]'));
    if Rewrite(cif)=0 then begin
     for i:=0 to Text_NumLn(txt)-1 do begin
      Writeln(Text_GetLn(txt,i));
      if IoResult<>0 then n:=n+1 else m:=m+1;
     end;
    end else n:=n+1;
    nrw:=iMax(0,m-3);
    iNul(Append(''));
    bNul(Text_Free(txt));
    if not IsBit(mode,2)
    or not IsBit(mode,3) then
    if not IsEmptyStr(bkp) then begin
     if not DirExists(bkp) then bNul(MkDir(AddBackSlash(bkp)));
     if not IsBit(mode,2) then begin
      bk1:=AddBackSlash(bkp)+ExtractFileName(cif)+'-'+
           StrReplace(StrReplace(GetDateTime(mSecNow),Dump('.'),'',3),Dump(':'),'',3)+ExtractFileExt(cif);
      bNul(FileCopy(Url_Packed(cif)+' '+Url_Packed(bk1)));
     end;
     if not IsBit(mode,3) then begin
      bk2:=AddBackSlash(bkp)+ExtractFileName(cif)+ExtractFileExt(cif);
      bNul(FileCopy(Url_Packed(cif)+' '+Url_Packed(bk2)));
     end;
    end;
   end;
   if n=0
   then Report(n,'SaveIni : saved '+Str(nrw)+' tags to '+ExtractFileName(cif)+ExtractFileExt(cif))
   else Report(n,'SaveIni : saved '+Str(nrw)+' tags to '+ExtractFileName(cif)+ExtractFileExt(cif)
                +' with '+Str(n)+' errors');
   if not IsEmptyStr(bk1) then if FileExists(bk1) then rNul(Eval('@system @async @silent @integrity --add '+bk1));
   if not IsEmptyStr(bk2) then if FileExists(bk2) then rNul(Eval('@system @async @silent @integrity --add '+bk2));
   if not IsEmptyStr(cif) then if FileExists(cif) then rNul(Eval('@system @async @silent @integrity --add '+cif));
  end;
  if Pos(UpCaseStr(RW),'RIL<')>0 then begin
   txt:=Text_New;
   if not IsEmptyStr(cis) then begin
    bNul(Text_Free(LoadTagValues(ReadIniSection(Text_New,28,'',cis),txt)));
    if not IsEmptyStr(cif) and FileExists(cif) then
    bNul(Text_Free(LoadTagValues(ReadIniSection(Text_New,28,cif,cis),txt)));
   end;
   nrw:=Text_NumLn(txt);
   Report(0,'LoadIni : loaded '+Str(nrw)+' tags from '+ExtractFileName(cif)+ExtractFileExt(cif));
   bNul(Text_Free(txt));
   if not IsEmptyStr(cif) then if FileExists(cif) then rNul(Eval('@system @async @silent @integrity --check '+cif));
  end;
  CustomIniRW:=nrw;
  cif:='';
  cis:='';
  ctl:='';
  bkp:='';
  bk1:='';
  bk2:='';
 end;
 {
 Find comma separated window list where curve is inside.
 }
 function WinListByCurve(crv:Integer; comma:Char):String;
 var list,win:String; n,m,i,j,t,c:Integer;
 begin
  list:=''; win:='';
  if not IsEmptyStr(CrvName(crv)) then for m:=1 to 2 do begin
   n:=0;
   repeat
    c:=0;
    win:=ParamStr(ExtractWord(m,'CURWINNAME,TABWINNAME')+' '+Str(n)); n:=n+1;
    if not IsEmptyStr(win) then begin
     t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(win,'[',']'));
     for i:=0 to Text_NumLn(t)-1 do
     if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'CurveList') then
     for j:=2 to WordCount(Text_GetLn(t,i)) do
     if IsSameText(ExtractWord(j,Text_GetLn(t,i)),CrvName(crv)) then c:=c+1;
     bNul(Text_Free(t));
     if c>0 then
     if IsEmptyStr(list) then list:=win else list:=list+comma+Trim(win);
    end;
   until IsEmptyStr(win);
  end;
  WinListByCurve:=list;
  list:=''; win:='';
 end;
 {
 Select windows where curve crv is inside. Also select curve selcrv.
 }
 function WinSelectByCurve(crv:Integer; selcrv:Integer):Integer;
 var list:String; i,n:Integer; comma:Char;
 begin
  n:=0;
  list:='';
  comma:=',';
  list:=WinListByCurve(crv,comma);
  for i:=1 to WordCountDelims(list,Dump(comma)) do begin
   bNul(WinSelect(ExtractWordDelims(i,list,Dump(comma))));
   if selcrv<>0 then bNul(WinDraw(ExtractWordDelims(i,list,Dump(comma))+'|SelectCurve='+CrvName(selcrv)));
   n:=n+1;
  end;
  WinSelectByCurve:=n;
  list:='';
 end;
 {
 Enumerate all devices n=0..NumDev-1
 }
 function DeviceListEnum(n:Integer):Integer;
 begin
  if not IsEmptyStr(ParamStr('DeviceName '+Str(n)))
  then DeviceListEnum:=RefFind('Device '+ParamStr('DeviceName '+Str(n)))
  else DeviceListEnum:=0;
 end;
 {
 Open calibration by curve.
 }
 function CalibrOpenByCurve(crv:Integer):Boolean;
 var n,nc,t,i,j,dev,cao,nao:Integer; b:Boolean;
 begin
  b:=false;
  if not IsEmptyStr(CrvName(crv)) then begin
   n:=0;
   repeat
    dev:=DeviceListEnum(n);
    if IsSameText(ParamStr('DeviceModel '+Str(n)),'Program') then
    if IsSameText(ParamStr('DeviceFamily '+Str(n)),'Software') then
    if dev<>0 then begin
     nc:=iValDef(ReadIni(StrAddBrackets(RefInfo(dev,'Name'),'[',']')+' Calibrations'),0);
     if nc>0 then begin
      t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(RefInfo(dev,'Name'),'[',']'));
      for i:=0 to Text_NumLn(t)-1 do
      if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'Link') then begin
       cao:=0; nao:=-1;
       for j:=2 to WordCount(Text_GetLn(t,i)) do begin
        if IsSameText(ExtractWord(j,Text_GetLn(t,i)),'Curve') then
        if IsSameText(ExtractWord(j+1,Text_GetLn(t,i)),CrvName(crv)) then cao:=crv;
        if IsSameText(ExtractWord(j,Text_GetLn(t,i)),'AnalogOutput')
        then nao:=iValDef(ExtractWord(j+1,Text_GetLn(t,i)),-1);
       end;
       if cao=crv then if nao>=0 then begin
        Cron('@Eval @System @Async @Silent @Open DAQ:\DeviceList\'
            +RefInfo(dev,'Name')+'\Calibration#'+Str(nao));
        b:=true;
        dev:=0;
       end;
      end;
      bNul(Text_Free(t));
     end;
    end;
    n:=n+1;
   until IsEmptyStr(RefInfo(dev,'Name'));
  end;
  CalibrOpenByCurve:=b;
 end;
 {
 Clear standard Utils.
 }
 procedure ClearStdUtils;
 begin
 end;
 {
 Initialize standard Utils.
 }
 procedure InitStdUtils;
 begin
  ShouldPollStdUtils:=false;
 end;
 {
 Finalize standard Utils.
 }
 procedure FreeStdUtils;
 begin
 end;
 {
 Poll standard Utils.
 }
 procedure PollStdUtils;
 begin
 end;
