 {
 ***********************************************************************
 Daq Pascal application program SmiSrv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @dim_dns_node n - Set default DIM_DNS_NODE=n
| @smitranslate f - Translate SML file (f) to SOBJ file
| @dimdnslaunch   - Check and launch local dns.exe
| @dim_send_command c - Send DIM command (c)
| @smismstart d s -dns n - start SMI domain (d) with SOBJ
|                          file (s) and dns node (n)
| @smismstop *    - stop all SMI domains
| @smismstop d    - stop SMI domain (d)
| @smismreport m  - print SMI report, m=0/1=not/detail
| @smismguard t   - start Guard with period t, ms; 0=OFF.
| @smismguard now - start Guard to check/restart smiSM`s.
|********************************************************
[]
 }
program SmiSrv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmiSmKillTimeout = 2000;        { Timeout to kill SMI processes    }
 SmiTransTimeout  = 4000;        { Timeout to translate SML file    }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 cmd_dim_dns_node     : Integer; { Command @dim_dns_node            }
 cmd_smitranslate     : Integer; { Command @smitranslate            }
 cmd_dimdnslaunch     : Integer; { Command @dimdnslaunch            }
 cmd_dim_send_command : Integer; { Command @dim_send_command        }
 cmd_smismstart       : Integer; { Command @smismstart              }
 cmd_smismstop        : Integer; { Command @smismstop               }
 cmd_smismreport      : Integer; { Command @smismreport             }
 cmd_smismguard       : Integer; { Command @smismguard              }
 def_dim_dns_node     : String;  { Default DIM_DNS_NODE             }
 DimSendCommandExe    : String;  { File dim_send_command.exe        }
 SmiTransExe          : String;  { File smiTrans.exe                }
 SmiSmExe             : String;  { File smiSm.exe                   }
 DnsExe               : String;  { File dns.exe                     }
 smismlist            : Integer; { Hash list of smiSM's             }
 SmiSmGuardTimer      : Real;    { SMI SM Guard Timer, ms           }
 SmiSmGuardPeriod     : Real;    { SMI SM Guard Period, ms          }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Return file in CommonProgramFiles.
 }
 function CommonProgFile(S:String):String;
 begin
  CommonProgFile:=AddPathDelim(GetEnv('CommonProgramFiles'))+S;
 end;
 {
 Return task status - DEAD/LIVE.
 }
 function GetTaskStatus(tid:Integer):String;
 begin
  if task_wait(tid,0)
  then GetTaskStatus:='LIVE'
  else GetTaskStatus:='DEAD';
 end;
 {
 Initialize (search) full file name Exe by short Name and (maybe) directory Dir.
 }
 procedure InitExeFile(var Exe:String; Name,Dir:String);
 var mode:Integer;
 begin
  Exe:='';
  mode:=AdaptFileNameMode(-1);
  iNul(AdaptFileNameMode(iAnd(mode,iNot(afnm_lower))));
  Name:=AdaptExeFileName(Name);
  if not IsEmptyStr(Dir) then Exe:=AddPathDelim(Trim(Dir))+Name;
  if not FileExists(Exe) then Exe:=ParamStr('FileSearch '+Name);
  if IsEmptyStr(Exe) or not FileExists(Exe)
  then Trouble('EXE file missed: '+Exe)
  else Success('EXE file found: '+Exe);
  iNul(AdaptFileNameMode(mode));
 end;
 {
 Translate *.SML file to *.SOBJ file.
 }
 function SmiTranslate(sml:String; Timeout:Integer):Boolean;
 var res:Boolean; tid,n:Integer; smi,sobj:String;
 begin
  res:=false;
  smi:=''; sobj:='';
  Success('SML translating: '+sml);
  if not IsEmptyStr(sml) then begin
   if IsSameText(ExtractFileExt(sml),'.sml') then begin
    sml:=DaqFileRef(sml,'');
    Success('SML File: '+sml);
    if FileExists(sml) then begin
     smi:=ForceExtension(sml,'.smi');
     sobj:=ForceExtension(sml,'.sobj');
     if FileCopy(sml+' '+smi) then begin
      tid:=task_init(SmiTransExe+' '+smi);
      sNul(task_ctrl(tid,'Display=SW_SHOWMINNOACTIVE'));
      sNul(task_ctrl(tid,'HomeDir='+ExtractFilePath(smi)));
      if task_run(tid) then begin
       bNul(task_wait(tid,Timeout));
       n:=task_result(tid);
       if (n=0)
       then Success('SML exit code '+Str(n)+' for '+ExtractFileName(sml)+ExtractFileExt(sml))
       else Problem('SML exit code '+Str(n)+' for '+ExtractFileName(sml)+ExtractFileExt(sml));
       res:=FileExists(sobj) and (n=0);
      end else Problem('SML run failed: '+SmiTransExe);
      bNul(task_free(tid));
     end else Problem('SML copy failed: '+sml);
     bNul(FileErase(smi));
    end else Problem('SML file not found: '+sml);
   end else Problem('SML extension wrong: '+sml);
  end else Problem('SML file empty');
  if res
  then Success('SML success: '+ExtractFileName(sobj)+ExtractFileExt(sobj))
  else Problem('SML failure: '+ExtractFileName(sobj)+ExtractFileExt(sobj));
  smi:=''; sobj:='';
  SmiTranslate:=res;
 end;
 {
 Check dns.exe running and launch.
 }
 function DimDnsLaunch:Boolean;
 var res:Boolean; tid,n:Integer;
 begin
  n:=PidCounter(AdaptExeFileName('dns.exe'));
  if (n=0) then begin
   tid:=task_init(AnsiQuotedStr(DnsExe,'"'));
   sNul(task_ctrl(tid,'HomeDir='+ExtractFilePath(DnsExe)));
   sNul(task_ctrl(tid,'Display=SW_HIDE'));
   if task_run(tid)
   then Success('DNS run PID '+Str(task_pid(tid))+' file '+DnsExe)    
   else Problem('DNS failed: '+DnsExe);
   bNul(task_free(tid));
   n:=PidCounter(AdaptExeFileName('dns.exe'));
  end else Success('DNS is already running');
  DimDnsLaunch:=(n>0);
 end;
 {
 Example: DimSendCommand('DEMO_SMI/EXIT 0 -dns localhost -i',1000);
 }
 function DimSendCommand(arg:String; Timeout:Integer):Boolean;
 var res:Boolean; tid,pid:Integer;
 begin
  res:=false;
  arg:=Trim(arg);
  if (arg<>'') and (Timeout>=0) then begin
   tid:=task_init(DimSendCommandExe+' '+arg);
   sNul(task_ctrl(tid,'HomeDir='+ExtractFilePath(DimSendCommandExe)));
   sNul(task_ctrl(tid,'Display=SW_HIDE'));
   if task_run(tid)
   then Success('DIM command: '+task_ctrl(tid,'CmdLine'))    
   else Problem('DIM failure: '+task_ctrl(tid,'CmdLine'));
   pid:=task_pid(tid); bNul(task_wait(tid,Timeout));
   if (pid>0) then res:=true;
   bNul(task_free(tid));
  end;
  DimSendCommand:=res;
 end;
 {
 @smismstart domain file.sobj [-dns localhost]
 }
 function SmiSmStart(arg:String):Boolean;
 var res:Boolean; tid,pid:Integer; dom,sobj,dns:String;
 begin
  res:=false; arg:=Trim(arg);
  dom:=''; sobj:=''; dns:='';
  if (WordCount(arg)>=2) then begin
   dom:=ExtractWord(1,arg); sobj:=ExtractWord(2,arg);
   if IsSameText(ExtractFileExt(sobj),'.sobj') then begin
    sobj:=DaqFileRef(sobj,'');
    if FileExists(sobj) then begin
     if IsSameText(ExtractWord(3,arg),'-dns') then dns:=ExtractWord(4,arg);
     if (dns='') then dns:=def_dim_dns_node;
     if (dns='') then dns:=GetEnv('DIM_DNS_NODE');
     if not IsEmptyStr(dns) then begin
      if (hashlist_indexof(smismlist,dom)<0) then begin
       tid:=task_init(SmiSmExe+' '+dom+' '+sobj+' -dns '+dns+' -d 9 -t');
       sNul(task_ctrl(tid,'HomeDir='+ExtractFilePath(SmiSmExe)));
       sNul(task_ctrl(tid,'Display=SW_HIDE'));
       if task_run(tid) then begin
        bNul(hashlist_setlink(smismlist,dom,tid));
        bNul(hashlist_setpara(smismlist,dom,arg));
        pid:=task_pid(tid);
        res:=(hashlist_getlink(smismlist,dom)>0);
        Success('SMI start PID '+Str(pid)+' from '+task_ctrl(tid,'CmdLine'));
        tid:=0; // No need to free
       end else Problem('SMI run failed: '+task_ctrl(tid,'CmdLine'));
       if (tid<>0) then bNul(task_free(tid));
      end else Problem('SMI domain already started: '+dom);
     end else Problem('SMI dns not specified');
    end else Problem('SMI SOBJ not found: '+sobj);
   end else Problem('SMI SOBJ extension wrong: '+sobj);
  end else Problem('SMI missed arguments: '+arg);
  dom:=''; sobj:=''; dns:='';
  SmiSmStart:=res;
 end;
 {
 Kill SMI process by domain, then (maybe) delete it from list.
 }
 function SmiSmKill(dom:String; delete:Boolean):Boolean;
 var res:Boolean; tid,n:Integer; dns:String;
 begin
  res:=false;
  dns:=''; dom:=Trim(dom);
  if not IsEmptyStr(dom) then
  if (hashlist_indexof(smismlist,dom)>=0) then begin
   tid:=hashlist_getlink(smismlist,dom);
   if task_wait(tid,0) then begin
    dns:=ExtractWord(5,task_ctrl(tid,'CmdLine'));
    if DimSendCommand(dom+'_SMI/EXIT 0 -dns '+dns+' -i',SmiSmKillTimeout)
    then bNul(task_wait(tid,SmiSmKillTimeout));
    if task_wait(tid,0) then bNul(task_kill(tid,0,0,0));
    n:=task_result(tid);
    if (n=0)
    then Success('SMI task stop: '+dom+' with exit code '+Str(n))
    else Problem('SMI task stop: '+dom+' with exit code '+Str(n));
   end;
   if delete then begin
    if (tid<>0) then
    if task_free(tid)
    then Success('SMI task free: '+dom)
    else Problem('SMI task free: '+dom);
    if hashlist_delete(smismlist,dom)
    then Success('SMI list free: '+dom)
    else Problem('SMI list free: '+dom);
   end; 
   res:=true;
  end;
  dns:='';
  SmiSmKill:=res;
 end;
 {
 @smismstop *
 @smismstop DEMO
 }
 function SmiSmStop(arg:String):Boolean;
 var res:Boolean; tid,w,i,n:Integer; dom:String;
 begin
  res:=false;
  dom:=''; n:=0;
  if (hashlist_count(smismlist)=0) then res:=true else
  if not IsEmptyStr(arg) then begin
   for w:=1 to WordCount(arg) do begin
    dom:=ExtractWord(w,arg);
    if (dom='*') then begin
     for i:=hashlist_count(smismlist)-1 downto 0 do
     if SmiSmKill(hashlist_getkey(smismlist,0),true) then n:=n+1;
    end else begin
     if SmiSmKill(dom,true) then n:=n+1;
    end;
   end;
   res:=(n>0);
  end else Problem('SMI arguments empy');
  dom:='';
  SmiSmStop:=res;
 end;
 {
 @smismreport m
 }
 procedure SmiSmReport(mode:Integer);
 var i,tid,pid,k,l,m:Integer; key,line:String;
 begin
  key:=''; line:='';
  Success(GetDateTime(mSecNow)+' = > SMI Report:');
  m:=1; k:=1;
  for i:=0 to hashlist_count(smismlist)-1 do begin
   key:=hashlist_getkey(smismlist,i);
   tid:=hashlist_getlink(smismlist,key);
   pid:=task_pid(tid);
   l:=Length(key);      if (l>m) then m:=l;
   l:=Length(Str(pid)); if (l>k) then k:=l;
  end;
  for i:=0 to hashlist_count(smismlist)-1 do begin
   key:=hashlist_getkey(smismlist,i);
   tid:=hashlist_getlink(smismlist,key);
   pid:=task_pid(tid);
   line:='SMI '+StrFmt('%-'+Str(m)+'s',key)+' => ';
   line:=line+GetTaskStatus(tid)+StrFmt(' PID %-'+Str(k)+'d => ',pid);
   if (mode=0)
   then line:=line+'smiSM '+hashlist_getpara(smismlist,key)
   else line:=line+task_ctrl(tid,'CmdLine');
   Success(line);
  end;
  key:=''; line:='';
 end;
 {
 SMI SM Guard Poll: Restart dead State Machines.
 }
 procedure SmiSmGuardCheck;
 var i,tid,pid:Integer; key,par:String;
 begin
  key:=''; par:='';
  for i:=0 to hashlist_count(smismlist)-1 do begin
   key:=hashlist_getkey(smismlist,i);
   tid:=hashlist_getlink(smismlist,key);
   par:=hashlist_getpara(smismlist,key);
   pid:=task_pid(tid);
   if not task_wait(tid,0) then begin
    Success('Restarting SMI domain '+key+' ...');
    if SmiSmStop(key) then bNul(SmiSmStart(par));
   end;
  end;
  key:=''; par:='';
 end;
 procedure SmiSmGuardPoll;
 begin
  if (SmiSmGuardPeriod>0) then
  if (msElapsedSinceMarker(SmiSmGuardTimer)>SmiSmGuardPeriod) then begin
   SmiSmGuardTimer:=mSecNow;
   SmiSmGuardCheck;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  def_dim_dns_node:='';
  DimSendCommandExe:='';
  SmiTransExe:='';
  SmiSmExe:='';
  DnsExe:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(60000,60000,3000,0);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmd_dim_dns_node:=RegisterStdInCmd('@dim_dns_node','');
  cmd_smitranslate:=RegisterStdInCmd('@smitranslate','');
  cmd_dimdnslaunch:=RegisterStdInCmd('@dimdnslaunch','');
  cmd_dim_send_command:=RegisterStdInCmd('@dim_send_command','');
  cmd_smismstart:=RegisterStdInCmd('@smismstart','');
  cmd_smismstop:=RegisterStdInCmd('@smismstop','');
  cmd_smismreport:=RegisterStdInCmd('@smismreport','');
  cmd_smismguard:=RegisterStdInCmd('@smismguard','');
  // Initialize files
  InitExeFile(DimSendCommandExe,'dim_send_command.exe','');
  InitExeFile(SmiTransExe,'smiTrans.exe','');
  InitExeFile(SmiSmExe,'smiSM.exe','');
  InitExeFile(DnsExe,'dns.exe',CommonProgFile('CRW-DAQ\Resource\DimSite\dim\bin'));
  smismlist:=hashlist_init(1);
  SmiSmGuardPeriod:=0;
  SmiSmGuardTimer:=0;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  bNul(SmiSmStop(Dump('*')));
  if (smismlist<>0) then begin
   bNul(hashlist_free(smismlist));
   smismlist:=0;
  end;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  SmiSmGuardPoll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; n:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @dim_dns_node localhost
   }
   if (cmdid = cmd_dim_dns_node) then begin
    if not IsEmptyStr(arg) then def_dim_dns_node:=Trim(arg);
    if (def_dim_dns_node='.') then def_dim_dns_node:='localhost';
    Success(cmd+'='+def_dim_dns_node);
    Data:='';
   end else
   {
   @smitranslate run_con.sml
   }
   if (cmdid = cmd_smitranslate) then begin
    n:=Ord(SmiTranslate(Trim(arg),SmiTransTimeout));
    Assertion(n>0,cmd+'='+Str(n));
    Data:='';
   end else
   {
   @dimdnslaunch
   }
   if (cmdid = cmd_dimdnslaunch) then begin
    n:=Ord(DimDnsLaunch);
    Assertion(n>0,cmd+'='+Str(n));
    Data:='';
   end else
   {
   @dim_send_command DEMO_SMI/EXIT 0 -dns localhost -i
   }
   if (cmdid = cmd_dim_send_command) then begin
    if not IsEmptyStr(arg)
    then n:=Ord(DimSendCommand(Trim(arg),0))
    else n:=0;
    Assertion(n>0,cmd+'='+Str(n));
    Data:='';
   end else
   {
   @smismstart DEMO file.sobj -dns localhost
   }
   if (cmdid = cmd_smismstart) then begin
    n:=Ord(SmiSmStart(Trim(arg)));
    Assertion(n>0,cmd+'='+Str(n));
    Data:='';
   end else
   {
   @smismstop *
   @smismstop DEMO
   }
   if (cmdid = cmd_smismstop) then begin
    n:=Ord(SmiSmStop(Trim(arg)));
    Assertion(n>0,cmd+'='+Str(n));
    Data:='';
   end else
   {
   @smismreport
   @smismreport 1
   }
   if (cmdid = cmd_smismreport) then begin
    SmiSmReport(Val(Trim(arg)));
    Data:='';
   end else
   {
   @smismguard now
   @smismguard 60000
   }
   if (cmdid = cmd_smismguard) then begin
    if not IsEmptyStr(arg) then begin
     if IsSameText(ExtractWord(1,arg),'now')
     then SmiSmGuardCheck else SmiSmGuardPeriod:=rValDef(ExtractWord(1,arg),SmiSmGuardPeriod);
     if (SmiSmGuardPeriod>0) then SmiSmGuardTimer:=mSecNow else SmiSmGuardTimer:=0;
    end;
    Success(cmd+'='+Str(SmiSmGuardPeriod));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
