
---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Преамбула

<a name="opcua-preambule"></a>

**[Здесь](./)** описывается сервер **opcuasrv**, являющийся сервером **OPCUA** общего назначения для пакета **crwdaq**.  
Сервер обеспечивает обмен данными между пакетом **crwdaq** и клиентами **OPCUA**, к которому они подключаются.  

Сервер состоит из:  

- оболочки (_wrapper_) - программы **[opcuasrv.pas](#opcuasrv-pas)** на языке **DaqPascal**,  
- серверной программы **[opcuasrv.py](#opcuasrv-py)** на языке программирования **Python**.  

Сначала ознакомьтесь с **[терминологией OPCUA](#opcua-base)**.  
Затем узнайте **[как работает сервер](#opcuasrv-work-overview)**.  
См. также **[заметки по OPCUA](../../manual/opcua-notes.htm)**.  

См. также монитор **[opcuamon](opcuamon.htm)**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Терминология OPCUA: server, client, namespace, node, alias

<a name="opcua-base"></a>

- Серверы (**server**) **OPCUA** - это процессы, публикующие данные в сети.  
  Клиенты (**client**) **OPCUA** - это процессы, использующие опубликованные данные.  
- Сервер **OPCUA** имеет сетевой адрес, например: **`opc.tcp://localhost:4840`**.  
  По этому адресу клиенты находят и подключаются к серверу в сети.  
- Ключевым понятием **OPCUA** является **узел** (**node**) - поименованный элемент данных.  
  Узлы имеют **имена** (для удобства людей) и числовые **индексы** (для быстрого доступа).  
  Все данные **OPCUA** располагаются в узлах.   
- Сервер **OPCUA** имеет массив **Пространств Имен** - **namespace**.  
  Пространства имен идентифицируются именами **URI**, например,  
  **`http://opcfoundation.org`**. Обычно используются имена, похожие  
  на имена сайтов, но это не строго - подойдут любые уникальные строки.  
- Каждое пространство имен содержит проиндексированный массив узлов.  
  Узлы в адресном пространстве могут иметь сложную структуру с вложенными узлами.  
  Но независимо от сложности каждый узел имеет свой уникальный индекс.  
- Простые узлы (переменные) содержат (скалярные) значения данных.  
  Обячно это именно то что нам надо.  
- Индексы узлов (в рамках данной конфигурации) должны быть постоянными.  
  Обычно массив имен вместе с индексами сохраняется в файл формата **XML**.  
  При запуске сервер читает конфигурацию **namespace** из этого файла.  
  В терминах **OPCUA** это называется **[моделью данных](#opcua-data-model)**.
- Для (быстрого) доступа к узлам используются **индексные идентификаторы** узлов.  
  Индекс **ns** пространства имен является первой координатой данных.  
  Индекс **i** узла в пространстве имен является второй координатой.  
  Узлы индексируются в виде канонического идентификатора **nodeId**  
  типа **`ns=2;i=2003`** по шаблону **`/^ns=(\d+);(i=\d+)$/i`**.  
- Кроме целочисленных индексов **i** могут использоваться строковые индексы **s**  
  или **g** (уникальные идентификаторы _guid_). В общем случае работает  
  шаблон индексного идентификатора **`/^ns=(\d+);(i=\d+|s=\S+|g=\S+)$/i`**.  
  Например, **`ns=2;i=2003`** или  **`ns=2;s=Tag321`**.  
- Для индексации узлов в сервере **OpcuaSrv** также используются:
  - Укороченные идентификаторы **nodeId** вида **`ns2i2003`** по шаблону **`/^ns(\d+)(i\d+)$/i`**,  
    или в общем случае  по шаблону **`/^ns(\d+)(i\d+|s\S+|g\S+)$/i`**.  
    Например, **`ns2i2003`** или  **`ns2sTag321`**.  
    Укороченные идентификаторы используются для облегчения синтаксического анализа,  
    а также для корректной передачи данных по каналам связи.  
  - Псевдонимы **alias**, являющиеся идентификаторами по правилам **Pascal**.  
    Псевдонимы используются для удобства конфигурирования и программирования.  

> Псевдонимы используются в программе сервера **OpcuaSrv** для понятности и читабельности,
  при выполнении программы псевдонимы автоматически заменяются на соответствующие индексы узлов.
  Псевдонимы **должны** быть простыми именами по правилам **Pascal** и **не должны** быть
  идентификаторами узлов, т.к. весь смысл псевдонимов состоит в замене **nodeId** на
  понятное (для программистов) читабельное имя.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Модель данных OPCUA

<a name="opcua-data-model"></a>

Сервер **OPCUA** работает с формализованной **моделью данных**.

С теоретической точки зрения **модель данных** - это формализованное описание данных,
которые публикует сервер, в виде сложно структурированной древовидной иерархии объектов,
включающей описание типов, переменных, свойств, методов и других элементов.

С практической точки зрения **модель данных** - это файл формата **`.xml`**,
который содержит описание публикуемых сервером данных.

Для создания и редактирования моделей данных есть редактор, который можно вызывать через
меню "**Старт/Панель Управления OPCUA**", либо командой:

``` bash
unix grun pyvenv opcua-modeler    # способ 1
unix opcua-cpl opcua-modeler-gui  # способ 2
```

При создании/редактировании узлов-переменных (в которых, собственно, и находятся данные),
следует обращать **особое** внимание на следующие **атрибуты** (в окне _Attributes editor_):

- **DataType** - тип данных. Рекомендуется использовать типы:  
  - **Int32 = 6** для целочисленных данных,  
  - **Double = 11** для вещественных данных,  
  - **LocalizedText = 21** для строковых данных.  
- **AccessLevel** - флаги режима доступа к данным,  
  - **CurrentRead** - разрешено чтение данных (по умолчанию включено),  
  - **CurrentWrite** - разрешена запись данных (по умолчанию отключено),  
- **UserAccessLevel** - флаги режима доступа к данным с учетом прав пользователя,  
  задается аналогично **AccessLevel** и используется в случае  
  разграничения прав пользователей.  

По умолчанию переменные создаются с правами чтения (для клиентов).
Если есть необходимость сделать переменные с правами записи (для клиентов),
то нужно либо задать флаг **AccessLevel/CurrentWrite** в модели данных,
либо использовать команду **`@OpcWritable …`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

# Как работает сервер

Программа **[opcuasrv.py](#opcuasrv-py)** используется в готовом виде, "как есть".  
Всё конфигурирование происходит на уровне оболочки **[opcuasrv.pas](#opcuasrv-pas)**.  

Оболочка полностью отвечает за интеграцию сервера в пакет **crwdaq**.

Для использования сервера нужно правильно **[сконфигурировать](#opcuasrv-config)** оболочку **[opcuasrv.pas](#opcuasrv-pas)**.  
При конфигурировании описываются подключения узлов **OPCUA** к кривым и тегами пакета **crwdaq**, а также способы их опроса и обновления.  

## Общая схема работы сервера

<a name="opcuasrv-work-overview"></a>

- Перед запуском сервера:  
  - Создается **модель данных** в виде **`.xml`** файла с описанием данных, их имен, типов и т.д.  
    Для создания модели данных можно использовать программу **FreeOpcua Modeler**.  
    Вызов: **`unix pyvenv opcua-modeler`**.  
  - Файл **`.xml`** с моделью данных помещается в папку конфигурации прикладной **DAQ** системы.  
    Он определяет данные, которые будет публиковать **OPCUA** сервер.  
- При старте системы:
  - Оболочка **[opcuasrv.pas](#opcuasrv-pas)** читает **[конфигурацию](#opcuasrv-config)** сервера.  
  - Оболочка **opcuasrv.pas** запускает серверную программу **[opcuasrv.py](#opcuasrv-py)**.  
  - Оболочка **opcuasrv.pas** конфигурирует серверную программу **opcuasrv.py**.  
  - Оболочка **opcuasrv.pas** инициирует цикл опроса сервера **opcuasrv.py**.  
  - Сервер **opcuasrv.py** загружает **модель данных** из **`.xml`** файла и публикует эти данные.  
- При работе системы:
  - Оболочка **opcuasrv.pas** прередает команды к и принимает сообщения от серверной программы **opcuasrv.py**.  
    Данные передаются по анонимным каналам связи (_pipe_) потоков ввода-вывода (_stdin_,_stdout_).  
  - Чтение данных от **OPCUA** идет по подписке. Оболочка обеспечивает прием данных от **opcuasrv.py**.  
  - Прикладной код может инициировать досрочное чтение данных командой **`@OpcuaNodeRead`**.  
  - Прикладной код может инициировать запись нужных данных командой **`@OpcuaNodeSend`**.  
    При записи серверная программа делает рассылки всем подключенным клиентам.  
  - Оболочка **opcuasrv.pas** записывает принятые данные в указанные при конфигурировании кривые и теги.  
  - Оболочка **opcuasrv.pas** может при поступлении данных посылать сообщения согласно конфигурации.  
    С помощью сообщений можно уведомлять о поступлении новых данных другие программы.  
  - Для понимания логики работы клиента и сервера нужно не забывать о наличии нескольких  
    **[копий данных](#data-and-copies)**, между которыми постоянно идет синхронизация.  
- При завершении системы
  - Оболочка **opcuasrv.pas** останавливает и завершает серверную программу **opcuasrv.py**.  


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Данные и копии данных сервера и клиента

<a name="data-and-copies"></a>

Работая с программами монитора (клиента) **[opcuamon](opcuamon.htm)** и сервера **[opcuasrv](opcuasrv.htm)** всегда надо помнить,
что в клиент-серверных программах всегда есть несколько копий данных:

- оригинальные (исходные) данные сервера - например, в базе данных сервера,  
- копия данных сервера в буфере передатчика сервера,  
- копия данных в буфере приемника клиента,  
- копия данных в программе клиента.  

В нормальной ситуации сервер и клиент стараются синхронизовать (обновлять) данные как можно скорее,
чтобы все копии данных соответствовали оригиналу (исходным данным сервера).
Однако, поскольку сервер и клиент работают в разных процессах, а приемник и передатчик - в разных потоках,
всегда существуют задержки с обновлениями, а потому эти четыре копии данных могут отличаться друг от друга.
Больше того, в некоторых ситуациях копии гарантированно отличаются. Например, когда клиент инициирует
команду записи, заранее предполагается, что текущая копия данных клиента отличается от (желаемых)
данных сервера. Целью записи является именно сстремление изменить данные сервера, чтобы затем сервер,
прислав обновление клиенту, изменил копию данных клиента на желаемое значение.
Больше того, в некоторых ситуациях копии гарантированно отличаются. Например, когда клиент инициирует
команду записи, заранее предполагается, что текущая копия данных клиента отличается от (желаемых)
данных сервера. Целью записи является именно сстремление изменить данные сервера, чтобы затем сервер,
прислав обновление клиенту, изменил копию данных клиента на желаемое значение.

В нашем случае имеется четыре возможные копии данных:

 - Оригинальные (исходные) данные сервера, которыми владеет оболочка **opcuasrv.pas**, 
   прямо связанная с ядром пакета **crwdaq** со стороны сервера.  
- Копия данных в программе **opcuasrv.py**, которая служит передатчиком **OPCUA** со стороны сервера.  
- Копия данных в программе **opcuamon.py**, которая служит приемником **OPCUA** со стороны клиента.  
- Копия данных в программе **opcuamon.pas**, которая связана с ядром пакета **crwdaq** со стороны клиента.  

Для понимания работы программ **opcuasrv** и **opcuamon** необходимо понимать, что всякое изменение данных
происходит путем последовательного изменения (синхронизации) указанных копий данных.

Например, если клиент вызывал команду **`@OpcNodeSend WaveStarted 1`**, происходит примерно следующее:

- Клиентская оболочка **opcuamon.pas** посылает программе **opcuamon.py** команду **`@OpcDataSend node 1`**  
  с именем узла **node**, соответствующем псевдониму **WaveStarted**.  
- Клиентская программа **opcuamon.py** декодирует команду и посылает в сеть запрос к серверу **OPCUA**.  
- Серверная программа **opcuasrv.py** принимает запрос **OPCUA** и передает его серверной оболочке **opcuasrv.pas**.  
- Серверная оболочка **opcuamon.pas** обращается к ядру пакета **crwdaq** и меняет данные.  
- Серверная оболочка **opcuamon.pas** посылает измененные данные серверной программе **opcuasrv.py**.  
- Серверная программа **opcuasrv.py** публикует измененные данные через протокол **OPCUA**.  
- Клиентская программа **opcuamon.py** получает обновление по подписке и передает его оболочке **opcuamon.pas**.  
- Клиентская оболочка **opcuamon.pas** получает обновленные данные и обновляет клиентскую копию данных  
  в ядре пакета  **crwdaq** со стороны клиента.  

В случае подключения к другому (внешнему) серверу **OPCUA** вместо серверной программы **opcuasrv.py**
и её оболочки **opcuasrv.pas** будет выступать внешний сервер (например, **SCADA**).
Но логика остается примерно такой же.
Понимание этой логики (наличие нескольких копий данных и синхронизация между ними)
позволит избежать ошибок.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

# Оболочка opcuasrv.pas

<a name="opcuasrv-pas"></a>

Оболочка сервера **[opcuasrv.pas](opcuasrv.pas)** содержит программу **DaqPascal**, которая
отвечает за приемопередачу данных **OPCUA** от серверной программы **opcuasrv.py** на стороне пакета **crwdaq**.
Задачей оболочки **opcuasrv.pas** является интеграция сервера в пакет **crwdaq**, включая функции
запуска остановки, конфигурирования и обмена данными с серверной программой **opcuasrv.py**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Конфигурирование opcuasrv.pas

<a name="opcuasrv-config"></a>

Конфигурирование **opcuasrv.pas** включает в себя:  

- **[Конфигурацию устройства](#opcuasrv-device)** - задание обычных параметров **DAQ**-устройства.  
- **[Задание секции StartupScript, FinallyScript](#opcuasrv-startup)** - для старта и завершения программы **opcuasrv.py**.  
- **[Задание псевдонимов](#opcuasrv-alias)** - фактически таблицы подключения узлов данных, к которым подключается и которые публикует сервер.  
- **[Задание секции StartServing](#opcuasrv-startserving)** - для подключения к **OPCUA** и наблюдения данных с помощью программы **opcuasrv.py**.  

Имеется пример **[demo_opcuamon](../../../demo/demo_opcuamon/)** демонстрационной конфигурации для иллюстрации работы сервера **opcuasrv**.
В конфигурации имеется **[справка](../../../demo/demo_opcuamon/help/index.htm)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Конфигурация устройства

<a name="opcuasrv-device"></a>

Для использования сервера **opcuasrv** надо создать **DAQ** устройство - например, **`&OpcuaSrv`**.

Самый простой способ - использовать **[default](../default/opcuasrv.cfg)**
конфигурацию **[opcuasrv.cfg](opcuasrv.cfg)** для
стандартного сервера **&OpcuaSrv**.  
Для этого достаточно добавить в конфигурацию код:

``` ini
[ConfigFileList] ; Default config for &OpcuaSrv
ConfigFile = ~~\resource\daqsite\default\opcuasrv.cfg
[]
```

Стандартная конфигурация хорошо подходит для большинства прикладных задач.  

Можно также сконфигурировать устройство вручную.  
Пример конфигурации устройства **`&OpcuaSrv`**:

``` bash
[DeviceList]
&OpcuaSrv = device software program
[&OpcuaSrv]
Comment       = OPCUA_SERVING_PROGRAM
InquiryPeriod = 1
DevicePolling = 10, tpNormal
ProgramSource = ~~\resource\daqsite\opcuaserver\opcuasrv.pas
DebugFlags    = 3
OpenConsole   = 2
StdInFifo     = 128
StdOutFifo    = 128
AnalogFifo    = 1000
DigitalFifo   = 1000
tagStdPyAppStat = Device/&OpcuaSrv/StdPyApp.Stat
tagOpcuaSrvStat = Device/&OpcuaSrv/OpcuaSrv.Stat
StartupScript = [&OpcuaSrv.StartupScript]
FinallyScript = [&OpcuaSrv.FinallyScript]
StartServingSection = [&OpcuaSrv.StartServing]
StartServingPattern = /^(@Opc\w+.*|@Py\w+\s.*)$/i
StartServingTrigger = Welcome to opcuasrv program.
DelayServingTrigger = 5000
FilterTooltipPattern = /^(info:|information:|warn:|warning:|error:|@warning|@error)\s/i
FilterConsolePattern = /^(info:|information:|warn:|warning:|error:)\s/i
tipInfoDelay = 15000
tipWarnDelay = 30000
tipErroDelay = 60000
[]

[TagList]
Device/&OpcuaSrv/StdPyApp.Stat = string  0
Device/&OpcuaSrv/OpcuaSrv.Stat = string  0
[]
```

Кроме обычных параметров устройства задаются:  

- **StdInFifo** - размер буфера **stdin**, килобайт. Буфер используется для чтения/записи данных из канала.  
- **StdOutFifo** - размер буфера **stdout**, килобайт. Буфер используется для чтения/записи данных из канала.  
- **StartupScript** - секция для команд инициализации. Эти команды выполняются при старте **DAQ** устройства.  
- **FinallyScript** - секция для команд завершения работы. Эти команды выполняются при остановке **DAQ** устройства.  
- **StartServingSection** - секция команд старта сервера. Эти команды выполняются при старте серверной программы.  
- **StartServingPattern** - шаблон команд старта сервера. Это регулярное выражение для допустимых команд старта сервера.  
- **StartServingTrigger** - строка - маркер старта сервера. Это строка подтверждения от сервера для начала его работы.  
- **DelayServingTrigger** - задержка старта сервера, **мс**. Задержка старта сервера нужна, чтобы сервер провел инициализацию.  
- **tagStdPyAppStat**     - имя строкового тега для хранения статистики **StdPyApp**.  
- **tagOpcuaSrvStat**     - имя строкового тега для хранения статистики **OpcuaSrv**.  
- **FilterTooltipPattern** - шаблон строк для вывода всплывающих сообщений.  
- **FilterConsolePattern** - шаблон строк для вывода консольных  сообщений.  
- **tipInfoDelay** - задержка для информационных всплывающих сообщений, мс. 
- **tipWarnDelay** - задержка для предупреждающих всплывающих сообщений, мс.  
- **tipErroDelay** - задержка для всплывающих сообщений об ошибках, мс.  

Тег **tagStdPyAppStat** определен так, чтобы гарантированно избежать конфликта имен.  
Этот тег содержит строку статистики в формате **cookie** списка:  
**`rss=RSS;vmd=VMS;gc=GE,OB,C0,C1,C2,GG,GW;poll=PC,PR,PW;ping=PT,PW;`**  
где:  
- **RSS** - _resident set size_ - размер резидентной памяти программы **opcuasrv.py** в байтах,  
- **VMS** - _virtual memory size_ - размер виртуальной памяти программы **opcuasrv.py** в байтах,  
- **GE** - флаг (**0/1**) разрешения сборщика мусора **gc.isenabled()**,  
- **OB** - счетчик всех (динамических) объектов **len(gc.get_objects())**,  
- **C0** - счетчик сборщика мусора для **0**-го поколения объектов **gc.getcount()[0]**,  
- **C1** - счетчик сборщика мусора для **1**-го поколения объектов **gc.getcount()[1]**,  
- **C2** - счетчик сборщика мусора для **2**-го поколения объектов **gc.getcount()[2]**,  
- **GG** - счетчик сборщика мусора для неопознанных объектов **len(gc.garbage)**,  
- **GW** - метка времени - когда обновлялась информация о памяти и сборщике мусора,  
- **PC** - _poll count_ - счетчик циклов опроса программы **opcuasrv.py**,  
- **PR** - _poll rate_ - частота циклов опроса программы **opcuasrv.py**,  
- **PW** - _poll when_ - метка времени когда обновлялись счетчики опроса,  
- **PT** - _ping time_ - время запроса-ответа в миллисекундах,  
- **PW** - _ping when_ - метка времени когда обновляялся **ping**.  

Тег **tagOpcuaSrvStat** определен так, чтобы гарантированно избежать конфликта имен.  
Этот тег содержит строку статистики в формате **cookie** списка:  
**`State=ST;ReadRate=RR;SendRate=SR;TimeStamp=TS;`**  
где:  
- **ST** - статус процесса: **DEAD**,**STARTING**,**PREPARING**,**RUNNING**,**STOPPED**,**RESTARTING**.  
- **RR** - частота чтения данных, операций в секунду,  
- **SR** - частота записи данных, операций в секунду,  
- **TS** - метка времени, **ms**.  

Тег **tagStdPyAppStat** позволяет клиентской программе наблюдать за работой программы **opcuasrv.py**,
чтобы была возможность изучать статистику её работы. При необходимости статистика извлекается из строки.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Секции StartupScript, FinallyScript

<a name="opcuasrv-startup"></a>

В этих секциях описываются действия при старте и завершении работы **DAQ**-системы.  
Секция завершения **FinallyScript** обычно пуста, т.к. после работы делать нечего.  
Секция **StartupScript** должна содержать команды запуска программы **opcuasrv.py**.  
Стандартный вид секции инициализации приведен ниже:  

``` ini
[&OpcuaSrv.StartupScript]                                       ; PyApp startup:
@PyApp Set Launch unix pyvenv                                   ; Command to launch script
@PyApp Set Script ~~/resource/daqsite/opcuaserver/opcuasrv.py   ; Target script pathname
@PyApp Set Params                                               ; Script parameters
@PyApp Set PingCall @PollCount                                  ; Command on ping task
@PyApp Add PingCall @Memory                                     ; Command on ping task
@PyApp Set AutoStart 1                                          ; Enable AutoStart
@PyApp Set PipeSizeKb 128                                       ; Pipe buffer size, KB
@PyApp Set PreferToSend 0                                       ; 0:devPost, 1:devSend
@PyApp Set TimeOutToSend 100                                    ; Timeout to send data, ms
@PyApp Set TimeOutToStop 1000                                   ; Timeout to stop task, ms
@PyApp Set GuardTimerPeriod 5000                                ; Timer period to AutoStart
@PyApp Set PingTimerPeriod 1000                                 ; Timer period to PingCall
@PyApp Set CalcPing 1                                           ; Flag - calc Ping time
[]

[&OpcUaMon.FinallyScript]
[]
```

В обычной ситуации нет необходимости менять эти секции.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Задание псевдонимов

<a name="opcuasrv-alias"></a>

Псевдонимы узлов используются для того, чтобы иметь возможность оперировать понятными (читабельными) именами
узлов данных вместо трудно понимаемых индексных идентификаторов.
Псевдонимы позволяют сосредоточить все проблемы подключения данных в одном месте, в описании псевдонимов,
а дальше работать в терминах предметной области, используя понятные для людей имена узлов.

Псевдонимы узлов задаются в секции устройства (например **[&OpcuaSrv]**) в формате строк:

``` bash
Alias name = node
```

где  

- **name** - читабельное имя (идентификатор по правилам **Pascal**), понятное программистам,  
- **node** - короткий индексный идентификатор узла, см. **[преамбулу](#opcua-preambule)**.  

Например:

``` bash
[&OpcuaSrv]
;***************************
;**** Alias to Node mapping:
;***************************
Alias WaveSin       = ns2i2003
Alias WaveCos       = ns2i2004
Alias WaveAmplitude = ns2i2005
Alias WaveFrequency = ns2i2006
Alias WaveNoise     = ns2i2007
Alias WaveStarted   = ns2i2008
[]
```

При выполнении программы сервера каждый псевдоним заменяется на короткий индексный идентификатор узла.

> Настоятельно рекомендуется задавать псевдонимы для **всех** используемых узлов и работать с псевдонимами,
  а не с индексными идентификаторами. Это облегчит написание кода и его сопровождение.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Задание списка связей Link node … with …

<a name="opcuasrv-link-node-with"></a>

Список связей задается в секции описания устройства, например, **`[&OpcuaSrv]`**.
Он задает связи узлов **OPCUA** с кривыми, тегами, сообщениями и атрибутами.  
Это связи указывают, куда и как "укладывать" полученные от сервера данные.  

Пример секции связей:

``` ini
[&OpcuaSrv]
;*****************************************
;**** Link nodes with tags/curves/messages
;*****************************************
Link node WaveSin       with AnalogOutput 0 tag DEMO_OPCUAMON.WAVE.SIN       monitor 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveCos       with AnalogOutput 1 tag DEMO_OPCUAMON.WAVE.COS       monitor 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveAmplitude with                tag DEMO_OPCUAMON.WAVE.AMPLITUDE refresh 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveFrequency with                tag DEMO_OPCUAMON.WAVE.FREQUENCY refresh 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveNoise     with                tag DEMO_OPCUAMON.WAVE.NOISE     refresh 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveStarted   with                tag DEMO_OPCUAMON.WAVE.STARTED   refresh 5000 message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
Link node WaveSin       with AnalogInput  0 tag DEMO_OPCUAMON.TEST           trigger 5000 :y message @DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data
[]
```

Общий формат:

``` bash
[&OpcuaSrv]
Link node n with (Analog|Digital)(Input|Output) i tag t (monitor|polling|trigger|refresh) p y message m
[]
# n - псевдоним или индексный идентификатор узла OPCUA
# i - номер подключения (Аналог|Цифрового)(Ввода|Вывода)
# t - имя подключеннного к узлу тега
# p - период проверки/обновления данных, мс
# y - необязательный тип триггера (:x|:y|:t), по умолчанию :y
# m - сообщение c подстановкой $node (идентификатор узла),
#     $alias (псевдоним узла), $data (значение данных)
```

Параметры **`(Analog|Digital)(Input|Output) i`**, **`tag t`**, **`message m`** - необязательны.  
Их можно не указывать, если они не нужны.  

Наличие ключевых слов **`Link node … with …`** - строго обязательно, их порядок имеет значение.  

Параметры **`Link node n with … (monitor|polling|trigger|refresh) p …`** строго обязательны.  

Параметр **`node n`** задает псевдоним или (короткий) индексный идентификатор узла.  
Рекомендуется всегда использовать псевдонимы - так будет легче понимать код.  

Параметры **`(monitor|polling|trigger|refresh) p y`** задают способ опроса:

- **monitor p** - читать данные по подписке, но при отсутствии обновлений читать данные по запросу с периодом **p** миллисекунд.  
  Для правильной работы должна быть оформлена подписка на данный узел.  
  Это основной режим работы сервера для наблюдения данных.  
  Для этого способа опроса узла **запись запрещена**.  
  При попытке записи узла регистрируется ошибка.  

- **polling p** - читать данные по явному клиентскому запросу с периодом **p** миллисекунд.  
  Этот метод подходит для чтения редко изменяемых данных без оформления подписки.  
  Для этого способа опроса узла **запись запрещена**.  
  При попытке записи узла регистрируется ошибка.  

- **trigger p y** - запись данных **по триггеру** (при изменении входных данных), но при отсутствии изменений  
  делать запись по таймеру с периодом не реже **p** миллисекунд. При этом учитывается **источник триггера**,  
  который указывает, что именно (абсцисса или ордината кривой или значение тега) считается триггером.  
  При этом чтение значений узла также происходит (аналогично режиму **monitor**).  
  Необязательный параметр **y** задает источник триггера на запись:  
  - **:x** - триггер на запись по изменению координаты **x** подключенной кривой,  
  - **:y** - триггер на запись по изменению координаты **y** подключенной кривой,  
  - **:t** - триггер на запись по изменению значения **t** подключенного тега,  
  - значение по умолчанию для триггера записи равно **:y**,  
  Этот метод подходит для записи часто или нерегулярно изменяемых данных.  
  Его можно считать основным методом для параметров, работающих на запись.  
  При этом узел работает также и на чтение значений с сервера.  
  При этом данные для записи читаются с **(Analog|Digital)Input**, либо **Tag**,  
  а прочитанные с сервера данные пишутся в **(Analog|Digital)Output** и **Tag**.  
  Поскольку тег может работать на чтение и запись, то учитывается источник триггера:  
  данные для записи из тега берутся только если указано значение **:t** параметра **y**.  

- **refresh p y** - запись данных по таймеру с периодом **p** миллисекунд без анализа изменений.  
  При этом чтение значений узла также происходит (аналогично режиму **monitor**).  
  Этот метод подходит для записи редко изменяемых данных.  

Заметим, что при указании периода опроса **p=0** чтение/запись по таймеру отключается.  
Это может быть полезно, чтобы читать/записывать данные только по (внешним) событиям.  

При работе по внешним событиям чтение/запись инициируется командами:

- **`@OpcNodeRead n`** - чтение с сервера значения узла **n**,  
- **`@OpcNodeSend n v`** - запись значения **v** в узел **n**,  
- **`@OpcNodePoke n s`** - запись значения из источника **s** в узел **n**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Объяснение режимов и триггеров

Для понимания работы сервера следует помнить, что клиент **OPCUA** - имеет лишь **[копию](#data-and-copies)**  
данных, которыми владеет сервер. Поэтому клиент не может изменить данные сразу, вместо этого он  
посылает серверу команду (запрос) на изменение данных на сервере. Затем, если сервер одобрил  
изменения, обновленные данные приходят клиенту по подписке (либо считываются клиентом явно),  
чтобы клиент обновил свою копию данных.

Режим **monitor p** с периодом таймера **p** является основным методом чтения (наблюдения) данных.  
Для правильной работы на узел должна быть оформлена подписка на обновления **`@OpcBooking …`**.  
Таймер **p** гарантирует, что чтение данных будет выполняться не реже **p** миллисекунд,  
даже если сервер долго не обновляет данные. При нулевом значении **p** таймер отключается.  
Нулевой таймер можно использовать для работы по событиям (посылкой явных команд чтения).  
При работе клиент сохраняет прочитанные с сервера данные в подключенные кривые  
**(Analog|Digital)Output …** и теги **Tag …**.  

Пример:

``` bash
# Чтение узла WaveSin по подписке, но не реже 5сек
Link node WaveSin with AnalogOutput 0 monitor 5000
```

Режим **polling p** с периодом таймера **p** является вспомогательным методом чтения редко изменяемых данных.  
Таймер **p** обеспечивает чтение данных с периодом **p** миллисекунд, даже если нет подписки на обновления.  
При нулевом значении **p** таймер отключается, автоматических обновлений при этом не происхоит.  
Нулевой таймер можно использовать для работы по событиям (посылкой явных команд чтения).  
При работе клиент сохраняет прочитанные с сервера данные в подключенные кривые  
**(Analog|Digital)Output …** и теги **Tag …**.  

Пример:

``` bash
# Чтение узла WaveSin без подписки, раз в 5сек
Link node WaveSin with AnalogOutput 0 polling 5000
```

Режим **trigger p y** с периодом таймера **p** является основным методом записи (и наблюдения) данных.  
Для правильной работы на узел должна быть оформлена подписка на обновления **`@OpcBooking …`**.  
Таймер **p** гарантирует, что запись и чтение данных будет идти не реже **p** миллисекунд,  
даже если сервер долго не обновляет данные. При нулевом значении **p** таймер отключается.  
Нулевой таймер можно использовать для работы по событиям (посылкой явных команд записи/чтения).  
Параметр **y** со значением по умолчанию **:y** задает источник триггера на запись.  
Источник **:y** - триггер записи при изменении координаты **y** подключенной кривой **(Analog|Digital)Input**.  
Источник **:x** - триггер записи при изменении координаты **x** подключенной кривой **(Analog|Digital)Input**.  
Источник **:t** - триггер записи при изменении значения **t** подключенного тега.  
При этом в подключенную кривую **(Analog|Digital)Output …** или тег **Tag …** идет сохранение   
значений узла, прочитанных с сервера, аналогично режиму **monitor p**.  

Пример:

``` bash
# Запись/чтение узла WaveSin по триггеру :y, но не реже 5сек
Link node WaveSin with AnalogInput 0 tag Demo.WaveSin trigger 5000 :y
```

Режим **refresh p y** работает аналогично режиму **trigger**, только триггер на запись по  
изменению значений не используется, а запись идет по таймеру **p** (или по внешним событиям).  
Источник триггера играет роль только при подключении тега - он указывает, что при записи данные  
следует брать из тега, если указано значение источника триггера **:t**.  
При этом в подключенную кривую **(Analog|Digital)Output …** или тег **Tag …** идет сохранение  
значений узла, прочитанных с сервера, аналогично режиму **monitor p**.  

Пример:

``` bash
# Запись/чтение узла WaveSin по таймеру 5сек
Link node WaveSin with AnalogInput 0 tag Demo.WaveSin refresh 5000 :y
```

Наконец, при указании нулевого таймера **p** чтение/запись ведется по событиям,  
т.е. по сообщениям **`@OpcNodeRead …`**, **`@OpcNodeSend …`**, **`@OpcNodePoke …`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Задание секции StartServing

<a name="opcuasrv-startserving"></a>

В этой секции описываются команды, вызываемые при старте сервера.
Исполняются только команды, подходящие под шаблон **StartServingPattern**.
Эти команды посылаются в консоль оболочки **opcuasrv.pas** для выполнения.

Монитор стартует только после получения от серверной программы **opcuasrv.py**
ключевой (триггерной) строки **StartServingTrigger**, а также после задержки
на заданную величину **DelayServingTrigger** миллисекунд.
Это нужно для правильного запуска серверной программы, т.к. ей требуется
некоторое время для проведения внутренней инициализации.

В секции старта сервера задаются параметры подключения к серверу **OPCUA**,
а также оформляется подписка на обновление нужных для работы узлов.
Затем делается старт цикла опроса сервера для начала обмена данными.
Также, если нужно, делается запись начальных значений некоторых узлов.

Пример типичной секции старта сервера:  

``` ini
[&OpcuaSrv.StartServing]                                        ; Start serving actions:
@OpcServName OpcuaSrv                                           ; Assign server name
@OpcXmlModel ../daqpas/wave-demo-server.xml                     ; Data Model XML File
@OpcNamespace http//freeopcua/defaults/modeler                  ; Assign server namespace
@OpcEndpoint opc.tcp://0.0.0.0:4840/daqgroup/demo               ; Set server endpoint URL
@OpcBooking  /how=(monitor|trigger|refresh)/i                   ; Subscribe (monitor|trigger|refresh) nodes
@OpcSubInter 1                                                  ; Subscription update interval, ms
@UseShortKey 1                                                  ; Flag to use short node id
@OpcServing                                                     ; Start serving
@OpcNodePoke WaveAmplitude :t                                   ; Assign node value from linked tag
@OpcNodePoke WaveFrequency :t                                   ; Assign node value from linked tag
@OpcNodePoke WaveNoise :t                                       ; Assign node value from linked tag
@OpcNodeSend WaveStarted 1                                      ; Write node value
[]
```

- Команда **@OpcServName n** - задает условное имя сервера.   
  Например, **`OpcuaSrv`**.  
- Команда **@OpcXmlModel x** - задает имя (путь) **XML** файла **x** с описанием **модели данных**.  
  Например, **`opcuasrv.xml`**.  
- Команда **@OpcNamespace n** - задает имя адресного пространства **n** с описанием **модели данных**.  
  Например, **`http//freeopcua/defaults/modeler`**.  
- Команда **@OpcEndpoint u** - задает адрес точки подключения **u** сервера в виде **URL**.  
  Например, **`opc.tcp://0.0.0.0:4840/daqgroup/demo`**.  
- Команда **@OpcBooking p** - задает список подписки на обновления данных в виде шаблона **p**,  
  который является регулярным выражением по правилам, принятым в пакете **crwdaq**.  
  Регулярное выражение проверяется для псевдонимов, индексных идентификаторов и атрибутов.  
  Например, **`/.*/`** задает все узлы, **`/Wave.*/i`** - псевдонимы, начинающиеся на **Wave**,  
  а **`/how=monitor/i`** - все узлы с атрибутом опроса в режиме **monitor**.  
- Команда **@OpcSubInter 1** - задает минимальный период обновления для подписки.  
  Данные клиента будут обновляться при изменении данных сервера, но не чаще заданного периода.  
  Это позволяет ограничить трафик, если сервер обновляется слишком часто и генерирует избыточный объем данных.  
- Команда **@OpcServing** - запускает сервер. Начинается  процесс примемо-передачи данных.  
  После старта сервера новые подписки делать уже нельзя. Поэтому все нужные подписки  
  надо делать до старта сервера.  
- Команда **@OpcNodePoke n s** - посылает запрос на запись значения из источника **s** в узел **n**.  
  В качестве имени узла указывается псевдоним или индексный идентификатор узла.  
  В качестве источника задается:  
  - **:t** - присоединенный тег, или  
  - **:y** - присоединенная кривая.  
- Команда **@OpcNodeSend n v** - посылает запрос на запись значения **v** в узел **n**.  
  В качестве имени узла указывается псевдоним или индексный идентификатор узла.  
- Команда **@OpcNodeRead n** - посылает запрос на чтение значения из узла **n**.  
  В качестве имени узла указывается псевдоним или индексный идентификатор узла.  
  Команда позволяет читать редко изменяемые данные, на которые не оформлена подписка.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Комады оболочки opcuasrv.pas

Ниже описаны команды консоли оболочки **opcuasrv.pas**.

Следует специально отметить, что консоли оболочки **opcuasrv.pas**
и сервера **opcuasrv.py** - это две разные консоли для двух разных
программных потоков, из не надо путать друг с другом.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcServName name

Команда **`@OpcServName name`** задает условное имя **name** для сервера **OPCUA**.

Например:

``` bash
@OpcServName  OpcuaSrv
```

Имя сервера **OPCUA** следует задавать в самом начале, **до старта** сервера командой **`@OpcServing`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNamespace n

Команда **`@OpcNamespace n`** задает имя адресного пространства **n** для модели данных сервера **OPCUA**.

Например:

``` bash
@OpcNamespace http//freeopcua/defaults/modeler
```

Важно, чтобы имя адресного пространства **n** совпадало с именем модели данных, загруженной из **XML** файла командой **@OpcXmlModel**.
Иначе сервер не сможет отыскать данные для подключения.

Имя адресного пространства сервера **OPCUA** следует задавать в самом начале, **до старта** сервера командой **`@OpcServing`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcEndpoint url

Команда **`@OpcEndpoint url`** задает адрес **URL** для точки подключения сервера **OPCUA**.

Например:

``` bash
@OpcEndpoint  opc.tcp://localhost:4840/daqgroup/demo
```

Здесь **4840** - стандартный **TCP** порт **OPCUA**, зарегистрированный
в **[IANA](https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.txt)**
как **OPC UA Connection Protocol**.
См. **[service-names-port-numbers.txt](../../guides/www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.txt)**.

Адрес точки подключения сервера **OPCUA** следует задавать в самом начале, **до старта** сервера командой **`@OpcServing`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcBooking pattern

Команда **`@OpcBooking pattern`** задает шаблон **pattern** (регулярное выражение)
для подписки на обновления данных от сервера **OPCUA**.

Например:

``` bash
@OpcBooking  /.*/i                              # подписка на все объявленные узлы
@OpcBooking  /Wave.*/i                          # подписка на все узлы с псевдонимами Wave*
@OpcBooking  /how=(monitor|trigger|refresh)/i   # подписка на узлы с типом опроса (monitor|trigger|refresh)
```

При подписке на данные сервер **OPCUA** будет присылать уведомлении об изменении данных при их обновлении на стороне сервера.

При правильном конфигурировании обновления будут автоматически записываться в подключенные кривые или теги, а также будут
посылаться сообщения, если они были указаны в конфигурации подключения узла.

Подписку на обновления данных сервера **OPCUA** следует делать **до старта** сервера командой **`@OpcServing`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcServing

Команда **`@OpcServing`** запускает цикл опроса серверной программы **opcuasrv.py**.
Перед запуском необходимо задать (как минимум) адрес сервера **@OpcAddress**
и шаблоны для подписки узлов **@OpcBooking**.

Например:

``` bash
@OpcServing   # запуск сервера
```

После запуска сервера должен начаться обмен данными с сервером **OPCUA**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNodeRead node

Команда **`@OpcNodeRead node`** посылает серверной программе **opcuasrv.py** запрос на чтение узла **node**.
В качестве имени узла задается псевдоним или индексный идентификатор узла.

Например:

``` bash
@OpcNodeRead WaveSin    # чтение узла с псевдонимом WaveSin
```

Команда чтения используется, если надо прочитать конкретный узел **досрочно**.
Это может быть узел, на который не была оформлена подписка, либо подписка была оформлена,
но данные почему-то долго не обновлялись.

При успешном выполнении данные будут (через некоторое время) присланы сервером.

Команда чтения работает только после старта цикла опроса сервера.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNodeSend node value

Команда **`@OpcNodeSend node value`** посылает серверной программе **opcuasrv.py** запрос
на запись в узел **node** значения **value** на стороне сервера **OPCUA**.
В качестве имени узла **node** задается псевдоним или индексный идентификатор узла.
Новое значение **value** передается в виде строки.

Например:

``` bash
@OpcNodeSend WaveAmplitude 3.14    # запись в узел с псевдонимом WaveAmplitude значения 3.14
```

Команда записи используется, чтобы задать узлу (переменной на стороне сервера) новое значение,
явно заданное в аргументе команды.

При успешном выполнении данные будут (через некоторое время) обновлены на стороне сервера.
Соответственно придет уведомление об изменении данных (если оформлена подписка).
Надо, однако, быть готовым к тому, что сервер может отклонить изменение, если оно не разрешено,
поэтому обновление данных может и не произойти.

Команда записи работает только после старта цикла опроса сервера.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNodePoke node source

Команда **`@OpcNodePoke node source`** посылает серверной программе **opcuasrv.py** запрос
на запись в узел **node** значения, взятого из источника **source**.

В качестве имени узла **node** задается псевдоним или индексный идентификатор узла.

Значениями источника **source** могут быть:

- **:t** - значение из подключенного тега (_Link node … with Tag …_),  
- **:x** - значение из подключенной кривой (_Link node … with (Analog|Digital)Input …_),  
- **:y** - значение из подключенной кривой (_Link node … with (Analog|Digital)Input …_).  

Например:

``` bash
@OpcNodePoke WaveAmplitude :t    # запись в узел с псевдонимом WaveAmplitude значения из присоединенног тега
```

Команда записи используется, чтобы задать узлу (переменной на стороне сервера) новое значение,
взяятое из присоединенного тега или кривой (вместо указания явного значения).

Команда записи работает только после старта цикла опроса сервера.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcInform topic

Команда **`@OpcInform topic`** печатает в консоли серверной оболочки **opcuasrv.pas** информацию
на тему **topic**:

- **`@OpcInform`** - выдает справку (список тем),  
- **`@OpcInform *`** - выдает информацию по всем темам,  
- **`@OpcInform Alias`** - выдает список псевдонимов,  
  Список выдается в виде **` a = n`**, где  
  **a** - псевдоним, **n** - короткий индексный идентификатор узла.  
- **`@OpcInform Links`** - выдает список связей узлов с хранилищем данных и атрибутами,  
  т.е. список подключений узлов к кривым и тегам, в также другие атрибуты узлов.  
  Атрибуты выдаются в формате **cookie** списка:  
  **` a - how=…;ttr=…;ali=…;nai=…;ndi=…;nao=…;ndo=…;tag=…;msg=…;`**, где  
  **how** - тип триггера (**monitor|polling|trigger|refresh**) и период таймера (**мс**) опроса,  
  **ttr** - источник триггера **x** (абсцисса), **y** (ордината) или **t** (значение тега),  
  **ali** - псевдоним узла, **nod** - индексный идентификатор узла,  
  **nai**,**ndi**,**nao**,**ndo** - номер аналого/цифрового входа/выхода,  
  **tag** - имя подключенного тега, **msg** - сообщение для посылки при обновлении данных,  
  с подстановкой в сообщении псевдонима **`$alias`**, узла **`$node`** и значения данных **`$data`**.  
- **`@OpcInform Books`** - список подписок на обновление данных,  
  выдается в формате **`a = booked`**, где **a** - псевдоним узла.  
- **`@OpcInform how`** - выдает тип триггера для каждого узла.  
  

Пример вывода команды **`@OpcInform`**:

``` bash
@opcinform
&OPCUAMON ! No topics specified.
&OPCUAMON : Available topics are:
&OPCUAMON :  Links - table of node links.
&OPCUAMON :  Alias - alias to node table.
&OPCUAMON :  Books - nodes booking table.
&OPCUAMON :  How   - node trig how table.
&OPCUAMON :  *     - all listed topics.
@opcinform *
&OPCUAMON : Alias to Node table:
 wavenoise     = ns2i2007
 wavesin       = ns2i2003
 wavecos       = ns2i2004
 wavefrequency = ns2i2006
 wavestarted   = ns2i2008
 waveamplitude = ns2i2005
&OPCUAMON : Table of Node links:
 wavenoise     - how=refresh 5000;tag=264;ali=wavenoise;nod=ns2i2007;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
 wavesin       - how=monitor 5000;nao=0;tag=265;ali=wavesin;nod=ns2i2003;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
 wavecos       - how=monitor 5000;nao=1;tag=266;ali=wavecos;nod=ns2i2004;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
 wavefrequency - how=refresh 5000;tag=262;ali=wavefrequency;nod=ns2i2006;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
 wavestarted   - how=refresh 5000;tag=261;ali=wavestarted;nod=ns2i2008;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
 waveamplitude - how=refresh 5000;tag=263;ali=waveamplitude;nod=ns2i2005;msg=@DevPost &DEMO_OPCUAMON.MAIN.CTRL OpcData $alias $data;
&OPCUAMON : Nodes Booking table:
 wavenoise     = Booked
 wavesin       = Booked
 wavecos       = Booked
 wavefrequency = Booked
 wavestarted   = Booked
 waveamplitude = Booked
&OPCUAMON : Node Trig How table:
 wavenoise     = refresh
 wavesin       = monitor
 wavecos       = monitor
 wavefrequency = refresh
 wavestarted   = refresh
 waveamplitude = refresh
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

# Монитор opcuasrv.py

<a name="opcuasrv-py"></a>

**[Здесь](./)** описывается серверная программа **[opcuasrv.py](opcuasrv.py)** - сервер для публикации данных **OPCUA**.  
Он написан на языке **Python** с использованием модулей **asyncua** и **pycrwkit**.  

Сервер **opcuasrv.py** используется в готовом виде, "**как есть**".  
Всё конфигурирование происходит на уровне оболочки **opcuasrv.pas**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Вызов программы opcuasrv.py

Программа **opcuasrv.py** вызывается командами:

``` bash
unix pyvenv opcuasrv.py                                 # простой вызов без параметров
unix pyvenv opcuasrv.py -u opc.tcp://localhost:4840     # вызов с указанием адреса сервера
unix pyvenv opcuasrv.py --url opc.tcp://localhost:4840  # вызов с указанием адреса сервера
```

Команда **`unix pyvenv …`** вызывает программу в (правильном) виртуальном окружении.  
Необязательная опция **`-u`** или **`--url`** задает адрес сервера для подключения.  
Сервер подключения может быть задан позже командой **@OpcServAddr**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Команды и сообщения opcuasrv.py

Ниже описаны команды консоли серверной программы **opcuasrv.py**.

Следует специально отметить, что консоли оболочки **opcuasrv.pas**
и сервера **opcuasrv.py** - это две разные консоли для двух разных
программных потоков, из не надо путать друг с другом.

Управление программой  **opcuasrv.py** и обмен данными идет с помощью консольных команд,
посылаемых клиентом в поток **stdin** и ответных сообщений от программы в потоке **stdout**.
Формат команд и сообщений - **текстовый**, в кодировке **utf8**, с обычным разделением на строки
с помощью разделителя строк **EOL**, равного **LF** под **Unix** или **CRLF** под **Windows**.

Команды задаются в формате **DaqScript**:  

- команда занимает всю строку до разделителя строк **EOL**,  
- первым символом и признаком команды является символ **`@`**,  
- после символа **`@`** следует непустой **идентификатор** команды,  
- после идентификатора может следовать пробел и **аргументы** (строка данных),  
- при наличии аргументов пробел после идентификатора команды строго обязателен,  
- идентификатор команды не чувствителен к регистру символов,  
- в общем случае регистр аргументов играет роль (это зависит от команды),  
- формат аргументов зависит от команды и описывается отдельно.  

Пример команд:

``` bash
@Help           # команда без аргументов
@Exit 1         # команда с аргументом 1
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @Help

Печатает справку по командам.

``` bash
@help
 @Help             -  print this help
 @Exit n           -  exit with code n
 @PingEcho s       -  print echo (for testing)
 @PollCount        -  print polling loop counter
 @PollPeriod n     -  set polling loop period n ms
 @TermOnError n    -  terminate on error flag (0/1)
 @Memory           -  get process memory rss,vms,gc
 @OpcServName n    -  get/set server name (n), like OpcuaSrv
 @OpcEndpoint u    -  get/set server endpoint URL (u), like opc.tcp://0.0.0.0:4840/daqgroup/crwdaq/server
 @OpcServAddr u    -  get/set server endpoint URL (u), like opc.tcp://0.0.0.0:4840/daqgroup/crwdaq/server
 @OpcNamespace n   -  get/set server namespace (n), like http//freeopcua/defaults/modeler
 @OpcNspArray      -  get list of namespaces available on server
 @OpcNspIndex      -  get index of server namespace in list of namespaces
 @OpcXmlModel x    -  get/set server XML model (x), like /mnt/data/home/alex/projects/sandbox/opcua/opcua_test/opcuasrv.xml
 @OpcWritable n    -  make client`s writable node (n), like ns=2;i=13 or ns2i13
 @OpcDataBook n    -  subscribe data change of node (n), like ns=2;i=13 or ns2i13
 @UseShortKey f    -  flag (0/1) to use short key (ns2i13 instead of ns=2;i=13)
 @OpcSubInter p    -  subscription interval (period) ms, default is 100
 @OpcStartSrv      -  start OPCUA server to publish nodes data
 @OpcDataVary n v  -  notification on node (n) changed to value (v)
 @OpcGotEvent e    -  notification on got event (e)
 @OpcDataSend n v  -  write node (n) value (v)
 @OpcDataRead n    -  read node (n) value
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @Exit n

Команда **`@Exit n`** завершает программу с кодом выхода **n**.
Код выхода необязателен, по умолчанию **0**.

Ответное сообщение: **`@Exit n`** - уведомляет о выполнении команды.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @PingEcho s

Команда **`@PingEcho s`** выводит в консоль **эхо** - т.е. саму себя.
Применяется для проверки связи (_ping_) и измерения времени отклика.

Ответное сообщение: **`@PingEcho s`** - уведомляет о выполнении команды.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @PollCount

Команда **`@PollCount`** используется для чтения счетчика циклов.
Счетчик циклов служит для оценки частоты цикла опроса команд и сообщений. 

Ответное сообщение: **`@PollCount n`** - возвращает значение счетчика циклов **n**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @PollPeriod n

Команда **`@PollPeriod n`** используется для чтения/записи периода опроса **n** цикла опроса команд и сообщений.
При отсутствии аргумента происходит чтение, при наличии - запись и чтение периода опроса.

Ответное сообщение: **`@PollPeriod n`** - возвращает значение периода опроса **n** в миллисекундах (**мс**).

Начальное значение периода опроса - **4** **мс**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @TermOnError n

Команда **`@TermOnError n`** читает/задает флаг **n = (0/1)** для обработки ошибок.
Если флаг установлен, при ошибках (исключениях) программа прекращает выполнение.

Ответное сообщение: **`@TermOnError n`** - возвращает значение флага.

Начальное значение флага - **0**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @Memory

Команда **`@Memory`** используется для чтения счетчиков памяти.

Ответное сообщение: **`@Memory rss=R; vms=V; gc=G`** - возвращает значение
счетчика резидентной памяти **R** и виртуальной памяти **V** в байтах,
а также счетчиков "**сборщика мусора**" (_garbage collection_) **G**.

- **rss** = _resident set size_ - резидентная (физическая) память,  
- **vms** = _virtual memory size** - виртуальная (логическая) память.  
- **gc** = _garbage collection_ - счетчики сборщика мусора.  

Счетчики сборщика мусора имеет формат **gc=ge,go,g0,g1,g2,gg**:

- **ge** - флаг (**0/1**) разрешения автоматического сборщика мусора.  
- **go** - счетчик всех доступных (динамических) объектов **python**.  
- **g0** - счетчик сбора мусора для объектов поколения 0.  
- **g1** - счетчик сбора мусора для объектов поколения 1.  
- **g2** - счетчик сбора мусора для объектов поколения 2.  
- **gg** - счетчик объектов, которые сборщик не смог удалить.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcServName

Команда **`@OpcServName n`** задает имя сервера **n**.

По умолчанию имя сервера **OpcuaSrv**.

> Имя сервера должно задаваться **ДО** старта сервера командой **`@OpcStartSrv`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcEndpoint

Команда **`@OpcEndpoint u`** задает адрес точки подключения сервера **u**.

Параметр **u** имеет формат **URL** (_universal resource location_),
например, **`opc.tcp://localhost:4840/daqgroup/crwdaq/server`**.
В качестве имени сервера допустимо использовать **IP** адрес **`0.0.0.0`**,
что означает "все сетевые адаптеры на данном компьютере".
Также можно указывать имя компьютера (_hostname_), ссылку **localhost**
или **IP** адрес конкретного сетевого адаптера.

Для связи можно использовать стандартный порт **OPCUA** номер **4840**.
Этот порт официально зарегистрирован в организации **IANA** под записью
**`opcua-tcp 4840 tcp "OPC UA Connection Protocol" [OPC_Foundation] [Randy_Armstrong] 2018-01-04`**.
Либо можно использовать альтернативный порт, например, **16550**.

Альтернативным способом задания адреса точки подключения является
опция командной строки **`-u url`** или **`--url url`** при вызове прграммы.
В этом случае команду можно не использовать.

По умолчанию используется адрес **`opc.tcp://0.0.0.0:4840/daqgroup/crwdaq/server`**.

> Адрес точки подключения сервера должен задаваться **ДО** старта сервера командой **`@OpcStartSrv`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcServAddr

Команда **`@OpcServAddr u`** является синонимом команды **`@OpcEndpoint u`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNamespace

Команда **`@OpcNamespace n`** задает имя **адресного пространства** (_namespace_) **n**.

У сервера может быть несколько адресных пространств, в которых расположены поименованные объекты.
Команда задает имя адресного пространства **модели данных**, которое будет публиковать сервер.

Предполагается, что **модель данных** загружается из **XML** файла командой **`@OpcXmlModel x`**.
Имя адресного пространства **x** должно совпадать с именем адресного пространства, которое сохранено
в **XML** файле модели данных, иначе сервер не сможет отыскать нужные данные.

По умолчанию используется адресное пространство **http//freeopcua/defaults/modeler**.  
Это имя адресного пространства по умолчанию для программы **opcua-modeler**,  
которая используется для создания и редактирования модели данных.

> Имя адресного пространства сервера должно задаваться **ДО** старта сервера командой **`@OpcStartSrv`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcNspArray

Команда **`@OpcNspArray`** выводят список **адресных пространств** (_namespace_) сервера.
Она носит информативный характер.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команды @OpcNspIndex

Команда **`@OpcNspIndex`** выводят индекс заданного **адресного пространства** (_namespace_) в массиве адресных пространств сервера.
Она носит информативный характер.

Возвращаемый индекс используется для построения индексных идентификаторов **`ns=…`**, используемых для доступа к данным.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команды @OpcXmlModel

Команда **`@OpcXmlModel x`** задает имя **x** для **XML** файла **модели данных**.

Имя файла должно быть задано абсолютным путем файла.
Оно может включать переменные среды окружения, например, **$CRW_DAQ_CONFIG_HOME_DIR/opcuasrv.xml**.

Задание файла **модели данных** является **обязательным** для работы сервера.

Альтернативным способом задания файла является
опция командной строки **`-x file.xml`** или **`--xml file.xml`** при вызове прграммы.
В этом случае команду можно не использовать.

> Имя файла модели данных сервера должно задаваться **ДО** старта сервера командой **`@OpcStartSrv`**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команды @OpcWritable

Команда **`@OpcWritable n`** задает для узла **n** разрешение на запись данных **клиентами**.
Если узел не имеет разрешения, попытка записи значения узла клиентами будет отвергнута.
При этом запись данных сервером разрешена всегда.

Другим способом задать для узла разрешение на запись данных клиентами является установка
флага **CurrentWrite** в свойстве **AccessLevel** и **UserAccessLevel** данного узла.
Это можно сделать при редактировании модели данных в редакторе **opcua-modeler**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcDataBook n

Команда **`@OpcDataBook n`** служит для подписки узла (_node_) с идентификатором **n**
на уведомления об изменении значения.  
Идентификатор **n** задается в полной форме вида (например) **`ns=2;i=13`** или короткой форме **`ns2i13`**.

Здесь:

- **ns** - сокращение от _name space_ - адресное пространство,  
- **2** - индекс адресного пространства в массиве адресных пространств,  
- **i** - сокращение от _index_ - индекс элемента в адресном пространстве,  
- **13** - индекс элемента в указанном  адресном пространстве,  

Ответное сообщение: **`@OpcDataBook n`** - уведомляет о выполнении команды.

Подписка должна выполняться (строго) до старта сервера командой **`@OpcStartSrv`**. 

В результате подписка сервер **OPCUA** будет посылать уведомления **`@OpcDataVary n v`**
про каждом изменении данных узла **n** на значение **v**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @UseShortKey f

Команда **`@UseShortKey f`** читает/задает флаг **f = (0/1)** для формата печати идентификаторов узлов.  
Если флаг установлен, при печати используется короткий формат (**`ns2i13`** вместо **`ns=2;i=13`**).

Ответное сообщение: **`@UseShortKey f`** - возвращает значение флага.

Начальное значение флага - **0**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcSubInter p

Команда **`@OpcSubInter p`** читает/задает интервал (период) опроса **p** для проверки обновления подписки узлов (_subscription interval_).  
Этот интервал определяяет частоту (периодичность) обновления данных на стороне клиента.   

Данные клиента будут обновляться с учетом двух факторов:  

- фактического обновления данных на стороне сервера,  
- заданного интервала обновления подписки,  

Другими словами, клиент будет получать обновления данных по факту изменения данных на стороне сервера,
но не чаще интервала обновления.

Например, при значении **`@OpcSubInter 1000`** (интервал одна секунда) обновления будут приходить
с периодичностью раз в секунду - но только для тех узлов, которые изменились за эту секунду.

Ответное сообщение: **`@OpcSubInter p`** - возвращает значение интервала обновления подписки.

Начальное значение интервала подписки - **100**.

Для получения максимальной частоты обновления используйте интервал обновления **`@OpcSubInter 1`**.  
В этом случае обновление данных на стороне клиента будет максимально приближено к обновлению данных на сервере.   

> Значение интервала обновления должно быть задано командой @OpcSubInter ДО старта сервера командой @OpcStartSrv.
  Попытка изменения интервала обновления после старта сервера будет (молча) проигнорирована.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcStartSrv

Команда **`@OpcStartSrv`** стартует сервер, т.е. начинает обмен данными, на которые была оформлена подписка.  
После старта сервера оформлять новые подписки уже нельзя вплоть до перезапуска программы сервера.

Ответное сообщение: **`@OpcStartSrv s`** - возвращает статус сервера **`s = (0|1)`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Сообшение @OpcDataVary n v

Сообшение **`@OpcDataVary n v`** посылается при получении от сервера обновления узла
с идентификатором **n** с новым значением **v**.  
Это сообщение является основным способом передачи данных от сервера при их изменении.

Клиент должен обновлять свои (локальные) копии данных при получении этого сообщения.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Сообшение @OpcGotEvent e

Сообшение **`@OpcGotEvent e`** посылается при получении от сервера события **e**.

Клиент должен выполнять обратотку событий при получении этого сообщения.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Сообшение @Error class e - m

Сообшение **`@Error class e - m`** посылается при возникновении ошибки (исключения) класса **e** с сообщением **m**.  
При этом программа может продолжить выполнение, если исключение было перехвачено и обработано.  
Но возможны и фатальные ошибки, при которых программа прекращает работу.  

Клиент должен выполнять обработку ошибок при получении этого сообщения.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcDataSend n v

Команда **`@OpcDataSend n v`** посылается для записи в узел с идентификатором **n** значения **v**.  
Сервер должен выполнить запись данных узла при получении этой команды.  
Команда работает только после старта сервера командой **@OpcStartSrv**.  

Ответное сообщение: **`@OpcDataSend n v`** - уведомляет о выполнении команды.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @OpcDataRead n

Команда **`@OpcDataRead n`** инициирует непоследственное (без подписки) чтение значения узла с идентификатором **n**.  
Используется для чтения редко изменяемых данных без подписки, либо для досрочного чтения данных.  
Команда работает только после старта сервера командой **@OpcStartSrv**.  

Ответное сообщение: **`@OpcDataRead n v`** - возвращает идентификатор узла **n** и его значение **v**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Пример сеанса работы opcuasrv.py

Здесь приведен пример сеанса работы **opcuasrv.py** с указанием направления передачи:

- **` < `** - ввод команд в поток **stdin** программы **opcuasrv.py**,  
- **` > `** - вывод сообщений программы **opcuasrv.py** в поток **stdout**,  

``` bash
> Start opcuasrv.
> Type '@Exit' to terminate.
> Type '@Help' to show help.
> Welcome to opcuasrv program.
< @OpcEndpoint  opc.tcp://0.0.0.0:4840/daqgroup/opcuasrv
< @OpcNamespace http//freeopcua/defaults/modeler
< @OpcServName  OpcuaSrv
< @OpcXmlModel  opcuasrv
< @UseShortKey  1
< 
< @OpcDataBook ns2i2003
< @OpcDataBook ns2i2004
< @OpcDataBook ns2i2005
< @OpcDataBook ns2i2006
< @OpcDataBook ns2i2007
< @OpcDataBook ns2i2008
< 
< @OpcWritable ns2i2005
< @OpcWritable ns2i2006
< @OpcWritable ns2i2007
< @OpcWritable ns2i2008
< 
< @OpcStartSrv
> @OpcEndpoint opc.tcp://0.0.0.0:4840/daqgroup/opcuasrv
> @OpcNamespace http//freeopcua/defaults/modeler
> @OpcServName OpcuaSrv
> @OpcXmlModel /mnt/data/home/alex/projects/daqgroup/suite/crwdaq/resource/daqsite/opcuaserver/opcua_test/opcuasrv.xml
> @UseShortKey 1
> @OpcDataBook ns=2;i=2003
> @OpcDataBook ns=2;i=2004
> @OpcDataBook ns=2;i=2005
> @OpcDataBook ns=2;i=2006
> @OpcDataBook ns=2;i=2007
> @OpcDataBook ns=2;i=2008
> @OpcWritable ns=2;i=2005
> @OpcWritable ns=2;i=2006
> @OpcWritable ns=2;i=2007
> @OpcWritable ns=2;i=2008
> @OpcStartSrv 1
> @OpcNspArray http://opcfoundation.org/UA/, urn:freeopcua:python:server, http//freeopcua/defaults/modeler
> @OpcNspIndex 2
> WARNING:asyncua.server.server:Endpoints other than open requested but private key and certificate are not set.
> @OpcNodeId ns2i2003 ns=2;i=2003 WaveSin 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveSin
> @OpcNodeId ns2i2004 ns=2;i=2004 WaveCos 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveCos
> @OpcNodeId ns2i2005 ns=2;i=2005 WaveAmplitude 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveAmplitude
> @OpcNodeId ns2i2006 ns=2;i=2006 WaveFrequency 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveFrequency
> @OpcNodeId ns2i2007 ns=2;i=2007 WaveNoise 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveNoise
> @OpcNodeId ns2i2008 ns=2;i=2008 WaveOn 0:Root/0:Objects/2:DaqGroupPublic/2:WaveDemo/2:WaveOn
> Try to subscribe 6 items
> INFO: Subscription done for 6 node(s).
> @OpcDataVary ns2i2003 None
> @OpcDataVary ns2i2004 None
> @OpcDataVary ns2i2005 None
> @OpcDataVary ns2i2006 None
> @OpcDataVary ns2i2007 None
> @OpcDataVary ns2i2008 None
> @OpcWritable ns2i2005
> @OpcWritable ns2i2006
> @OpcWritable ns2i2007
> @OpcWritable ns2i2008
> @OpcDataRead ns2i2003
< @OpcDataSend ns2i2003 3.14
< @OpcDataRead ns2i2003
< @OpcDataSend ns2i2003 3.0
> @OpcDataSend ns2i2003 3.0
> @OpcDataRead ns2i2003 3.0
> @OpcDataSend ns2i2003 3.14
> @OpcDataRead ns2i2003 3.14
> @OpcDataVary ns2i2003 3.0
> @OpcDataVary ns2i2003 3.14
< @Exit
> Program terminated. Press Enter to exit.
> @Exit 0
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования **opcuasrv**.

---

> **CRW-DAQ** Copyright (c) 2001-2025 Alexey Kuryakin <daqgroup@mail.ru>

---
