#!/bin/bash

#####################################################
# Copyright (c) 2001-2024 DaqGroup <daqgroup@mail.ru>
#####################################################

##########################################################
# UART Configuration generator.
##########################################################
# PipeLine configure template:
# PipeLine = Com Port 1 Baudrate 9600 Parity NONE DataBits 8 StopBits 1  ; COM port
# PipeLine = Pipe DEMO Polling 4 Priority tpHighest                      ; Pipe DEMO (server)
# PipeLine = Pipe .\DEMO Polling 4 Priority tpHighest                    ; Pipe DEMO (client)
# PipeLine = Tcp Port 1234 Server 1 Polling 4 Priority tpHighest         ; Socket TCP:1234 (server)
# PipeLine = Tcp Port 1234 Client localhost Polling 4 Priority tpHighest ; Socket TCP:1234 (client)
##########################################################

# script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

# Initialize Variables
######################
readonly uart_cfg="$scriptbase.cfg"

function com_port_table(){
 add_header;
 ############ Port  BaudRate Parity DataBits StopBits PipeLine
 add_com_port COM1  115200   NONE   8        1        "Com Port 1 Baudrate 115200 Parity NONE DataBits 8 StopBits 1";
 add_com_port COM2  115200   NONE   8        1        "Com Port 2 Baudrate 115200 Parity NONE DataBits 8 StopBits 1";
 add_com_port COM3  115200   NONE   8        1        "Com Port 3 Baudrate 115200 Parity NONE DataBits 8 StopBits 1";
 add_com_port COM4  115200   NONE   8        1        ;
 add_com_port COM5  115200   NONE   8        1        ;
 add_com_port COM6  115200   NONE   8        1        ;
 add_com_port COM7  115200   NONE   8        1        ;
 add_com_port COM8  115200   NONE   8        1        ;
 add_com_port COM9  115200   NONE   8        1        ;
 add_com_port COM10 115200   NONE   8        1        ;
 add_com_port COM11 115200   NONE   8        1        ;
 add_com_port COM12 115200   NONE   8        1        ;
 add_com_port COM13 115200   NONE   8        1        ;
 add_com_port COM14 115200   NONE   8        1        ;
 add_com_port COM15 115200   NONE   8        1        ;
 add_com_port COM16 115200   NONE   8        1        ;
 add_com_port COM17 115200   NONE   8        1        ;
 add_com_port COM18 115200   NONE   8        1        ;
 add_com_port COM19 115200   NONE   8        1        ;
 add_com_port COM20 115200   NONE   8        1        ;
 add_com_port COM21 115200   NONE   8        1        ;
 add_com_port COM22 115200   NONE   8        1        ;
 add_com_port COM23 115200   NONE   8        1        ;
 add_com_port COM24 115200   NONE   8        1        ;
 add_com_port COM25 115200   NONE   8        1        ;
 add_com_port COM26 115200   NONE   8        1        ;
 add_com_port COM27 115200   NONE   8        1        ;
 add_com_port COM28 115200   NONE   8        1        ;
 add_com_port COM29 115200   NONE   8        1        ;
 add_com_port COM30 115200   NONE   8        1        ;
 add_com_port COM31 115200   NONE   8        1        ;
 add_com_port COM32 115200   NONE   8        1        ;
};

function add_header(){
 echo ";**************";
 echo "; UART Settings";
 echo ";**************";
};

function add_com_port(){
 local port="$1";     shift;
 local baudrate="$1"; shift;
 local parity="$1";   shift;
 local databits="$1"; shift;
 local stopbits="$1"; shift;
 local pipeline="$1"; shift;
 echo "[SerialPort-$port]";
 if [ "$pipeline" != "" ]; then echo "PipeLine = $pipeline"; fi;
 echo "Port     = $port";
 echo "BaudRate = $baudrate";
 echo "Parity   = $parity";
 echo "DataBits = $databits";
 echo "StopBits = $stopbits";
 echo "[]";
 echo "";
};

function delete_files(){
 while [ -n "$1" ]; do
  if [ -e "$1" ]; then rm -f "$1"; fi;
  shift;
 done;
};

function main(){
 if pushd $scriptHOME >/dev/null 2>&1; then
  delete_files $uart_cfg;
  com_port_table | tee -a $uart_cfg;
 fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
