@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: CRW-DAQ script to write event message to SysLog journal.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

chcp 65001 >nul

if not defined CRW_DAQ_VAR_TMP_DIR ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

:Identification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"

:Main
call :SetSysLog
call :datetime_prompt
if not "%~1" == "" call :SysLogNote "!prompt!%~1"
if not "%~2" == "" call :SysLogNote "!prompt!%~2"
if not "%~3" == "" call :SysLogNote "!prompt!%~3"
if not "%~4" == "" call :SysLogNote "!prompt!%~4"
if not "%~5" == "" call :SysLogNote "!prompt!%~5"
if not "%~6" == "" call :SysLogNote "!prompt!%~6"
if not "%~7" == "" call :SysLogNote "!prompt!%~7"
if not "%~8" == "" call :SysLogNote "!prompt!%~8"
if not "%~9" == "" call :SysLogNote "!prompt!%~9"
goto :EOF

:SetSysLog
set "syslog=%CRW_DAQ_VAR_TMP_DIR%\sys.log"
goto :EOF

:datetime_prompt
set "ms=000"
for /f "tokens=* delims=" %%i in ('%scripthome%\shell\date.exe "+%%Y.%%m.%%d-%%H:%%M:%%S.%ms% => "') do set "prompt=%%~i"
goto :EOF

:print
if "%~1" == "" goto :EOF
<nul set /p "_=%~1"
goto :EOF

:echo
:println
if "%~1" == "" goto :EOF
<nul set /p "_=%~1"
goto :EOF

:SysLogNote
unix printf "%%s\n" "%~1" | unix unix2dos | unix tee -a "%syslog%"
goto :EOF
