##############################################################
### Copyright 2020 Alexey Kuryakin kouriakine@mail.ru   ######
##############################################################
### Installer for VisualTech DieselPascal by Yuriy Kopnin ####
##############################################################

##############################################################
### Load language files.
##############################################################
LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Russian.nlf"

##############################################################
### General product dependent constants.
##############################################################
!define DistrTypeIsRuntime
!ifdef DistrTypeIsRuntime
 !define DistrType "Runtime"
!else
 !define DistrType "Design"
!endif
!define ProductTm "VisualTech"
!define ProductId "DieselPascal"
!define VersionId "2.1.6 Build 16.06.2023"
Name "${ProductTm} ${ProductId} ${DistrType}"
OutFile "Install${ProductId}${DistrType}.exe"
InstallDir "$TEMP\${ProductTm}\${ProductId}${DistrType}"
LangString CaptionText ${LANG_ENGLISH} "Install $(^Name) (Ver ${VersionId})"
LangString CaptionText ${LANG_RUSSIAN} " $(^Name) (Ver ${VersionId})"
Caption "$(CaptionText)"

##############################################################
### General installer options.
##############################################################
SetCompressor /FINAL /SOLID lzma
SetCompressorDictSize 64
SetDatablockOptimize on
SetCompress force
CRCCheck force
XPStyle on
SetFont "Courier New" 12
InstallColors AAAAAA 000000
InstProgressFlags smooth colored
ShowInstDetails show
ShowUninstDetails show

##############################################################
### Compilation time scripts.
##############################################################
!system "cmd /c if exist $(^OutFile) del /f /q  $(^OutFile)"

##############################################################
### License page.
##############################################################
Page License
LicenseLangString LicenseSource ${LANG_ENGLISH} "license.txt"
LicenseLangString LicenseSource ${LANG_RUSSIAN} "license.txt"
LicenseData $(LicenseSource)

##############################################################
### InstFiles page. Put installation sections there.
##############################################################
Page InstFiles

LangString SectionCheckAccessRights ${LANG_ENGLISH} "Check access rights..."
LangString SectionCheckAccessRights ${LANG_RUSSIAN} "  ..."
Section "-$(SectionCheckAccessRights)"
  SectionIn RO # Section is read-only
  Call CheckAccessRights
SectionEnd

LangString SectionProductExtract ${LANG_ENGLISH} "Extract ${ProductId}"
LangString SectionProductExtract ${LANG_RUSSIAN} " ${ProductId}"
Section "!$(SectionProductExtract)"
  SectionIn RO # Section is read-only
  SetShellVarContext all
  DetailPrint ""
  DetailPrint "Extract ${ProductId} files..."
  DetailPrint ""
  SetOutPath "$INSTDIR"
  Delete "$INSTDIR\*.*"
 #File /r "*.*"
  File DieselPascal.7z
!ifndef DistrTypeIsRuntime
  File DieselPascalDesign.7z
!endif
  File DieselPascalConfig.7z
  File getfilesize.cmd
  File handleopenwithmenu.cmd
  File InstallDieselPascal.cmd
  File UnInstallDieselPascal.cmd
  File 7za.exe
  File InstallDieselPascalRuntime.nsi
  File InstallDieselPascalDesign.nsi
  File license.txt  
SectionEnd

LangString SectionProductInstall ${LANG_ENGLISH} "Install ${ProductId}"
LangString SectionProductInstall ${LANG_RUSSIAN} " ${ProductId}"
Section "!$(SectionProductInstall)"
  SectionIn RO # Section is read-only
  SetShellVarContext all
  #ExecWait "Install${ProductId}.cmd"
  nsExec::Exec /OEM /TIMEOUT=600000 'cmd /c "Install${ProductId}.cmd"'
  Pop $0 # return value/error/timeout
  DetailPrint "Return value: $0"
  nsExec::Exec /OEM /TIMEOUT=10000 'ping -n 3 127.0.0.1' # delay 3 sec
  Pop $0 # return value/error/timeout
  DetailPrint "Return value: $0"
SectionEnd

LangString SectionCheckErrors ${LANG_ENGLISH} "Check errors..."
LangString SectionCheckErrors ${LANG_RUSSIAN} " ..."
LangString CheckErrorsOkMsg ${LANG_ENGLISH} "Ok, no errors found during installation."
LangString CheckErrorsOkMsg ${LANG_RUSSIAN} "Ok,     ."
LangString CheckErrorsFailsMsg ${LANG_ENGLISH} "ATTENTION: some errors found during installation!"
LangString CheckErrorsFailsMsg ${LANG_RUSSIAN} ":     ."
Section "-$(SectionCheckErrors)"
  SectionIn RO # Section is read-only
  IfErrors +2 0
  DetailPrint "$(CheckErrorsOkMsg)"
  IfErrors 0 +2
  DetailPrint "$(CheckErrorsFailsMsg)"
SectionEnd

##############################################################
### Select installation language dialog.
##############################################################
Function SelectLanguageDialog
  IfSilent DoSilent DoSelection
  DoSilent:
   Push ${LANG_ENGLISH}  # English on silent
   Pop $LANGUAGE
   Goto DoExit
  DoSelection:
   Push ""               # for the auto count to work the first empty push (Push "") must remain
   Push ${LANG_RUSSIAN}  # Russian
   Push Russian
   Push ${LANG_ENGLISH}  # English
   Push English
   Push A                # A means auto count languages
   LangDLL::LangDialog "Installer Language" "Please select the language of the installer"
   Pop $LANGUAGE
   StrCmp $LANGUAGE "Cancel" 0 +2
    Abort
  DoExit:
FunctionEnd
##############################################################
Function un.SelectLanguageDialog
  IfSilent DoSilent DoSelection
  DoSilent:
   Push ${LANG_ENGLISH}  # English on silent
   Pop $LANGUAGE
   Goto DoExit
  DoSelection:
   Push ""               # for the auto count to work the first empty push (Push "") must remain
   Push ${LANG_RUSSIAN}  # Russian
   Push Russian
   Push ${LANG_ENGLISH}  # English
   Push English
   Push A                # A means auto count languages
   LangDLL::LangDialog "Uninstaller Language" "Please select the language of the uninstaller"
   Pop $LANGUAGE
   StrCmp $LANGUAGE "Cancel" 0 +2
    Abort
  DoExit:
FunctionEnd
##############################################################

##############################################################
### Check if LANGUAGE is valid to use.
##############################################################
Function CheckLanguage
  StrCmp $LANGUAGE ${LANG_ENGLISH} LANGUAGE_OK +1
  StrCmp $LANGUAGE ${LANG_RUSSIAN} LANGUAGE_OK +1
  MessageBox MB_OK "Invalid LANGUAGE selected ($LANGUAGE)."
  Abort "Invalid LANGUAGE selected ($LANGUAGE)."
  LANGUAGE_OK:
FunctionEnd
##############################################################
Function un.CheckLanguage
  StrCmp $LANGUAGE ${LANG_ENGLISH} LANGUAGE_OK +1
  StrCmp $LANGUAGE ${LANG_RUSSIAN} LANGUAGE_OK +1
  MessageBox MB_OK "Invalid LANGUAGE selected ($LANGUAGE)."
  Abort "Invalid LANGUAGE selected ($LANGUAGE)."
  LANGUAGE_OK:
FunctionEnd
##############################################################

##############################################################
### Check user account type.
### If it is not "Admin", ask user to continue or abort...
##############################################################
Function CheckAccessRights
  Call CheckLanguage
  StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
   DetailPrint "Now checking user access rights..."
  StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
   DetailPrint "  ..."
  ClearErrors
  Var /GLOBAL UserName
  UserInfo::GetName
  IfErrors AccessWin9x
  Pop $UserName
  Var /GLOBAL AccountType
  UserInfo::GetAccountType
  IfErrors AccessWin9x
  Pop $AccountType
  StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
   DetailPrint 'Found user "$UserName" of type "$AccountType".'
  StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
   DetailPrint '  "$UserName"  "$AccountType".'
  StrCmp $AccountType "Admin" AccessGranted AccessConfirmation
  AccessConfirmation:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
    MessageBox MB_YESNO 'User "$UserName" of type "$AccountType" \
                         have no Administrator rights. \
                         Application may work incorrectly after such installation. \
                         Continue installation?' \
                         IDYES AccessGranted IDNO AccessDenied
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
    MessageBox MB_YESNO ' "$UserName"  "$AccountType" \
                            . \
                               . \
                            ?' \
                         IDYES AccessGranted IDNO AccessDenied
  AccessDenied:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +4
    DetailPrint 'Access denied to user "$UserName" of type "$AccountType".'
    MessageBox MB_OK 'Access denied to user "$UserName" of type "$AccountType".'
    Abort 'Access denied to user "$UserName" of type "$AccountType".'
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +4
    DetailPrint '    "$UserName"  "$AccountType".'
    MessageBox MB_OK '    "$UserName"  "$AccountType".'
    Abort '    "$UserName"  "$AccountType".'
  AccessWin9x:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
    DetailPrint "Don't care about rights in Windows 9x."
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
    DetailPrint "      Windows 9x."
  AccessGranted:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +3
    DetailPrint 'Access granted to user "$UserName" of type "$AccountType".'
    DetailPrint 'Now can continue installation...'
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +3
    DetailPrint '     "$UserName"  "$AccountType".'
    DetailPrint '  ...'
FunctionEnd
##############################################################
Function un.CheckAccessRights
  Call un.CheckLanguage
  StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
   DetailPrint "Now checking user access rights..."
  StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
   DetailPrint "  ..."
  ClearErrors
  #Var /GLOBAL UserName
  UserInfo::GetName
  IfErrors AccessWin9x
  Pop $UserName
  #Var /GLOBAL AccountType
  UserInfo::GetAccountType
  IfErrors AccessWin9x
  Pop $AccountType
  StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
   DetailPrint 'Found user "$UserName" of type "$AccountType".'
  StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
   DetailPrint '  "$UserName"  "$AccountType".'
  StrCmp $AccountType "Admin" AccessGranted AccessConfirmation
  AccessConfirmation:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
    MessageBox MB_YESNO 'User "$UserName" of type "$AccountType" \
                         have no Administrator rights. \
                         Uninstallation may fails. \
                         Continue uninstallation?' \
                         IDYES AccessGranted IDNO AccessDenied
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
    MessageBox MB_YESNO ' "$UserName"  "$AccountType" \
                            . \
                            . \
                            ?' \
                         IDYES AccessGranted IDNO AccessDenied
  AccessDenied:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +4
    DetailPrint 'Access denied to user "$UserName" of type "$AccountType".'
    MessageBox MB_OK 'Access denied to user "$UserName" of type "$AccountType".'
    Abort 'Access denied to user "$UserName" of type "$AccountType".'
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +4
    DetailPrint '    "$UserName"  "$AccountType".'
    MessageBox MB_OK '    "$UserName"  "$AccountType".'
    Abort '    "$UserName"  "$AccountType".'
  AccessWin9x:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
    DetailPrint "Don't care about rights in Windows 9x."
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
    DetailPrint "      Windows 9x."
  AccessGranted:
   StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +3
    DetailPrint 'Access granted to user "$UserName" of type "$AccountType".'
    DetailPrint 'Now can continue uninstallation...'
   StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +3
    DetailPrint '     "$UserName"  "$AccountType".'
    DetailPrint '  ...'
FunctionEnd
##############################################################

##############################################################
### .onInit - installer initialization function.
##############################################################
Function .onInit
  Call SelectLanguageDialog
  Call CheckLanguage
FunctionEnd
##############################################################

##############################################################
### un.onInit - uninstaller initialization function.
##############################################################
Function un.onInit
  Call un.SelectLanguageDialog
  Call un.CheckLanguage
FunctionEnd
##############################################################
