 {
 ***********************************************************************
 DUH - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @AssignTag t v         - assign value v to tag t.
|********************************************************
[]
 }
program duh_main_ctrl;           { DUH - main control program       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 AwakePeriod       = 100;        { Period of checks to awake DatSrv }
 MaxUHs            = 8;          { Max. number of UniHeat heaters   }
 NumUHs            = 3;          { Number of UniHeat heaters        }

type
 TTagRef   = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DUH               : record      { All Demo UniHeat data            }
  CMD              : record      { CoMmandDs to control GUI         }
   HELP            : TTagRef;    { Open Help                        }
   HOME            : TTagRef;    { Exec Home                        }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   LOADINI         : TTagRef;    { Load INI file                    }
   SAVEINI         : TTagRef;    { Save INI file                    }
   TOOLS           : TTagRef;    { Tools menu                       }
   SOUND           : TTagRef;    { Sound menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
  end;                           {                                  }
  AwokeTime        : Real;       { Time when DatSrv last awoke      }
  DatSrvGate       : TTagRef;    { Save data to DatSrv              }
 end;                            {                                  }
 UH_EBLK           : array[1..MaxUHs] of TTagRef;   { Ext. blocking }
 UH_HENABL         : array[1..MaxUHs] of TTagRef;   { Heater enable }
 UH_SOUNDX         : TTagRef;    { Enable sound                     }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DUH.AwokeTime:=mSecNow;
  DevSendCmd(devDatSrv,'  ');
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then begin
   ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
   +' btn1 Справка cmd1 "cmd /c start '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm')+'"');
   if Pos(':',s)>0 then s:=Trim(Copy(s,Pos(':',s)+1));
   if iGetTag(UH_SOUNDX.tag)<>0 then Speak(s);
  end;
 end;
 {
 DUH clear strings
 }
 procedure DUH_CLEAR;
 begin
 end;
 {
 DUH initialization
 }
 procedure DUH_INIT;
 var i:Integer;
 begin  
  {
  Initialize tags & devices...
  }
  InitTag(DUH.DatSrvGate.tag,   'DATSRV.GATE',                      1);
  InitTag(DUH.CMD.HELP.tag,     ReadIni('tagDUH')+'.CMD.HELP',      1);
  InitTag(DUH.CMD.HOME.tag,     ReadIni('tagDUH')+'.CMD.HOME',      1);
  InitTag(DUH.CMD.OPEN.tag,     ReadIni('tagDUH')+'.CMD.OPEN',      1);
  InitTag(DUH.CMD.SAVE.tag,     ReadIni('tagDUH')+'.CMD.SAVE',      1);
  InitTag(DUH.CMD.LOADINI.tag,  ReadIni('tagDUH')+'.CMD.LOADINI',   1);
  InitTag(DUH.CMD.SAVEINI.tag,  ReadIni('tagDUH')+'.CMD.SAVEINI',   1);
  InitTag(DUH.CMD.TOOLS.tag,    ReadIni('tagDUH')+'.CMD.TOOLS',     1);
  InitTag(DUH.CMD.SOUND.tag,    ReadIni('tagDUH')+'.CMD.SOUND',     1);
  InitTag(DUH.CMD.SMILE.tag,    ReadIni('tagDUH')+'.CMD.SMILE',     1);
  InitTag(DUH.CMD.CLOSE.tag,    ReadIni('tagDUH')+'.CMD.CLOSE',     1);
  for i:=1 to MaxUHs do begin
   InitTag(UH_EBLK[i].tag,'UH_EBLK'+Str(i),1);
   InitTag(UH_HENABL[i].tag,'UH_HENABL'+Str(i),1);
   bNul(iSetTag(UH_HENABL[i].tag,Ord(i<=NumUHs)));
  end;
  InitTag(UH_SOUNDX.tag,'UH_SOUNDX',1);
  {
  Initialize values
  }
  DUH.CMD.CLOSE.val:=-1;
  DUH.CMD.SMILE.val:=GetErrCount(-2);
  DUH.AwokeTime:=0;
 end;
 {
 DUH finalization
 }
 procedure DUH_FREE;
 begin
 end;
 {
 DUH polling
 }
 procedure DUH_POLL;
 var nerrors:Real; i,ClickCurve:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(DUH.DatSrvGate.tag,Ord(iGetTag(DUH.CMD.SAVE.tag)<>0)));
   bNul(iSetTag(UH_SOUNDX.tag,Ord(iGetTag(DUH.CMD.SOUND.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if iGetTag(DUH.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
   bNul(iSetTag(DUH.CMD.HELP.tag,0));
  end;
  if iGetTag(DUH.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run DUH.MAIN.GUI.HOME');
   bNul(iSetTag(DUH.CMD.HOME.tag,0));
  end;
  if iGetTag(DUH.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DUH.CMD.OPEN.tag,0));
  end;
  if iGetTag(DUH.CMD.LOADINI.tag)<>0 then begin
   DevSendCmdLocal('@LoadIni');
   bNul(iSetTag(DUH.CMD.LOADINI.tag,0)); 
  end;
  if iGetTag(DUH.CMD.SAVEINI.tag)<>0 then begin
   DevSendCmdLocal('@SaveIni');
   bNul(iSetTag(DUH.CMD.SAVEINI.tag,0));
  end;
  if iGetTag(DUH.CMD.TOOLS.tag)<>0 then begin
   bNul(iSetTag(DUH.CMD.TOOLS.tag,0));
  end;
  if iGetTag(DUH.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(DUH.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DUH.CMD.SMILE.val then bNul(iSetTag(DUH.CMD.SMILE.tag,2)) else
   if iGetTag(DUH.CMD.SMILE.tag)>1 then bNul(iSetTag(DUH.CMD.SMILE.tag,1));
   DUH.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit tags...
  }
  if EditStateDone then begin
   {
   CLOSE menu.
   }
   MenuCloseHandler;
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Dialog error detected!');
   EditReset;
  end;
  {
  Handle left button clicks...
  }
  if (ClickButton=VK_LBUTTON) then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(DUH.CMD.HELP.tag,1);
   ClickBitXorLocal(DUH.CMD.HOME.tag,1);
   ClickBitXorLocal(DUH.CMD.OPEN.tag,1);
   ClickBitXorLocal(DUH.CMD.SAVE.tag,1);
   ClickBitXorLocal(DUH.CMD.LOADINI.tag,1);
   ClickBitXorLocal(DUH.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(DUH.CMD.TOOLS.tag,1);
   ClickBitXorLocal(DUH.CMD.SOUND.tag,1);
   ClickBitXorLocal(DUH.CMD.CLOSE.tag,1);
   if ClickTag=DUH.CMD.SAVE.tag then begin
    bNul(iSetTag(DUH.DatSrvGate.tag,Ord(iGetTag(DUH.CMD.SAVE.tag)<>0)));
    if iGetTag(DUH.CMD.SAVE.tag)<>0 then AwakeDatSrv;
   end;
   {
   Smile face button...
   }
   if ClickTag=DUH.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(DUH.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
   {
   Calibrations
   }
   if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
    bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
    bNul(Voice(snd_Click));
   end;
   {
   Cron actions
   }
   if IsSameText(Copy(Trim(ClickSensor),1,6),'@Cron.') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Device messages
   }
   if IsSameText(Copy(Trim(ClickSensor),1,8),'@DevMsg+') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Handle right button clicks...
  }
  if (ClickButton=VK_RBUTTON) then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DUH_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  DUH_INIT;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  DUH_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DUH_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n,tag,crv:Integer; r,a,b:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @AssignTag UH_NAMES T1/T2/T3
   }
   if IsSameText(cmd,'@AssignTag') then begin
    tag:=FindTag(ExtractWord(1,arg));
    if TypeTag(tag)>0 then UpdateTag(tag,Trim(SkipWords(1,arg)),_MinusInf,_PlusInf);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
