 {
 ***********************************************************************
 Daq Pascal application program SmiProxyLogger.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @smi_proxy cmd - Send command (cmd) to smiProxy.exe.
|********************************************************
[]
 }
program SmiProxyLogger;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_SmiProxy}              { Include SMI Proxy    constants   }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_SmiProxy}              { Include SMI Proxy    variables   }
 tagDelay      : Integer;        { Delay to simulate real work      }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_SmiProxy}              { Include SMI Proxy    functions   }

 procedure InitLogger;
 begin
  InitTag(tagDelay, ReadIni('tagPrefix')+'.SimDelay', -1);
 end;

 //
 // SMI Proxy Logic.
 //
 procedure SmiProxyLogic;
 var complete:Boolean; delay:Integer;
 begin
  //
  // Delay to simulate operation execution
  //
  delay:=iGetTag(tagDelay);
  //
  // SMI Proxy BUSY operations.
  // SMI actions handler there.
  //
  if smi_proxy_handler_busy then begin
   complete:=false;
   if smi_test_action('LOG') then begin
    complete:=true;
    if complete then begin
     smi_terminate_action('LOGGING');
    end;
   end else
   if smi_test_action('NOLOG') then begin
    complete:=true;
    if complete then begin
     smi_terminate_action('NOT_LOGGING');
    end;
   end else
   if smi_test_action('X_OPEN_FILE') then begin
    complete:=(smi_proxy_handler_uptime>delay);
    if complete then begin
     smi_terminate_action('WRITING');
    end;
   end else
   if smi_test_action('X_CLOSE_FILE') then begin
    complete:=(smi_proxy_handler_uptime>delay);
    if complete then begin
     smi_terminate_action('LOGGING');
    end;
   end else
   begin // Unknown action came
    smi_terminate_action('ERROR');
    Problem('Unknown action came: '+smi_proxy_handler_action);
   end;
  end else
  //
  // SMI Proxy IDLE operations.
  // Do when actions completed.
  //
  if smi_proxy_handler_idle then begin
   // To do on idle...
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearSmiProxy;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(0,60000,0,3000);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitSmiProxy;
  InitLogger;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeSmiProxy;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollSmiProxy then PollSmiProxy;
  SmiProxyLogic;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   !!! Handle SMI Proxy by default handler !!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   }
   if smi_proxy_default_handler(Data,cmd,arg,cmdid) then begin
    if (Data<>'') then Success(smi_proxy_prompt+Data);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
