########################################################################################################################
# State Manager Language (SML) Source file.
# Extra cookies uses for GUI declarations:
#  !visible: v      - Action visability (v=0/1) in popup menu.
#  !color: c        - Display color (c) for entity declared above.
#  !panel: p        - Panel name (p) to be opened on click. Substututions (_DOMAIN_,_OBJECT_,_STATE_,_ACTION_) is allowed.
#  !title: t        - Display title (t) for entity declared above.
#  !busy_title: t   - Display title (t) for BUSY state.
#  !busy_color: c   - Display color (c) for BUSY state.
#  !confirm: c      - Action required (c=0/1) confirmation dialog.
########################################################################################################################
!title: ВС
!busy_title: &ЗАНЯТ
!busy_color: FwStateAttention1

# Vacuum System Section class
#############################

class: SECT_CLASS /associated
!color: Silver
    state: DEAD /dead_state                                 !color: FwDead
    state: OFF /initial_state                               !color: _BtnFace
        action: GO_STANDBY                                  !visible: 1
    state: STANDBY                                          !color: FwStateOKNotPhysics
        action: GO_MANUAL                                   !visible: 1
        action: SWITCH_OFF                                  !visible: 1
        action: OPEN_SECTION                                !visible: 1
    state: MANUAL                                           !color: _BtnFace
        action: GO_STANDBY                                  !visible: 1
    state: READY                                            !color: FwStateOKPhysics
        action: CLOSE_SECTION                               !visible: 1
    state: CLOSED                                           !color: FwStateOKNotPhysics
        action: GO_STANDBY                                  !visible: 1
        action: OPEN_SECTION                                !visible: 1
    state: WARNING                                          !color: FwAlarmWarnAck
        action: RESET                                       !visible: 1
        action: OPEN_SECTION                                !visible: 1
        action: CLOSE_SECTION                               !visible: 1
    state: ERROR                                            !color: FwAlarmFatalAck
        action: RESET                                       !visible: 1

object: SEC1 is_of_class SECT_CLASS
object: SEC2 is_of_class SECT_CLASS
object: SEC3 is_of_class SECT_CLASS
object: SEC4 is_of_class SECT_CLASS
object: SEC5 is_of_class SECT_CLASS
object: SEC6 is_of_class SECT_CLASS

objectset: SECTIONS is_of_class VOID {SEC1,SEC2,SEC3,SEC4,SEC5,SEC6}
