program DemoEdit;
const
 sndClick     = 'Click';
var
 b             : boolean;
 Ok            : boolean;
 i,pl,pt,pr,pb : integer;
 errors        : integer;
 errcode       : integer;
 s,WinName     : string;
 tagEditState  : integer;
 tagEdit1      : integer;
 tagEdit2      : integer;
 tagEdit3      : integer;
 MainMenu      : Boolean;
 ToolBar       : Boolean;
 StatusBar     : Boolean;
 DaqSystem     : Boolean;
 r             : Real;
 {
 Language string: LangStr('ru "Русский язык" en "English language"');
 }
 function LangStr(arg:String):String;
 var ru,en,p1,p2,ls:String; i,n,lng,ien,iru:Integer;
  procedure Cleanup;
  begin
   ru:=''; en:=''; p1:=''; p2:=''; ls:=''; i:=0;
  end;
 begin
  Cleanup;
  n:=PhraseCount(arg);
  while (i<n-1) do begin
   i:=i+1; p1:=ExtractPhrase(i,arg);
   i:=i+1; p2:=ExtractPhrase(i,arg);
   if IsSameText(p1,'ru') then ru:=p2;
   if IsSameText(p1,'en') then en:=p2; 
  end;
  ien:=Round(Eval('lng_english'));
  iru:=Round(Eval('lng_russian'));
  lng:=Round(Eval('guilanguage()'));
  ls:=en;
  if (lng=ien) and (en<>'') then ls:=en;
  if (lng=iru) and (ru<>'') then ls:=ru;
  LangStr:=ls;
  Cleanup;
 end;
 {
 Инициирует диалог-предупреждение
 }
 procedure Warning(msg:string);
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else writeln(msg);
 end;
 {
 Инициирует диалог редактирования тега
 }
 procedure StartEditTag(tag:integer; Caption,Comment:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(igettag(tag)) else
    if typetag(tag)=2 then s:=str(rgettag(tag)) else
    if typetag(tag)=3 then s:=sgettag(tag) else s:='';
    if pos('?',edit('('+Caption)
              +edit(' '+Comment+'|'+s)
              +edit(')StringGridEdit '+nametag(tag)))>0
    then writeln('Error starting "'+Comment+'"!');
   end else Warning('Could not edit "'+Comment+'" now!');
  end;
  s:='';
 end;
 {
 Анализирует редактирование тега.
 }
 procedure CheckEditTag(tag:integer);
 var s,d:string; r:real; b:boolean;
 begin
  s:='';
  d:='';
  r:=0;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)=nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if not isnan(r) then b:=isettag(tag,round(r));
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if not isnan(r) then b:=rsettag(tag,r);
     end;
     if typetag(tag)=3 then b:=ssettag(tag,s);
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Ошибка ввода!')
  end;
  s:='';
  d:='';
 end;
 {
 Спрятать\показать основное меню
 }
 procedure DoMainMenu;
 begin
  if MainMenu
  then r:=eval('@system @async @view show FormCrwDaq.MainMenu')
  else r:=eval('@system @async @view hide FormCrwDaq.MainMenu');
  MainMenu:=not MainMenu;
  b:=voice(sndClick);
 end;
 {
 Спрятать\показать панель инструментов
 }
 procedure DoToolBar;
 begin
  if ToolBar
  then r:=eval('@system @async @view show FormCrwDaq.ToolBar')
  else r:=eval('@system @async @view hide FormCrwDaq.ToolBar');
  ToolBar:=not ToolBar;
  b:=voice(sndClick);
 end;
 {
 Спрятать\показать статусную строку
 }
 procedure DoStatusBar;
 begin
  if StatusBar
  then r:=eval('@system @async @view show FormCrwDaq.StatusBar')
  else r:=eval('@system @async @view hide FormCrwDaq.StatusBar');
  StatusBar:=not StatusBar;
  b:=voice(sndClick);
 end;
 {
 Спрятать\показать DAQ SYSTEM
 }
 procedure DoDaqSystem;
 begin
  if DaqSystem
  then r:=eval('@system @async @view norm FormDaqControlDialog')
  else r:=eval('@system @async @view min  FormDaqControlDialog');
  DaqSystem:=not DaqSystem;
  b:=voice(sndClick);
 end;
 {
 Выход из DAQ
 }
 procedure DoExitDaq;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(sndClick);
 end;
 {
 Выход из CRW
 }
 procedure DoExitCrw;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async _Crw_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @menu run FormCrwDaq.ActionFileExit');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(sndClick);
 end;
 {
 Выход из Windows через 15 сек
 How = l/s/r = logout/stop/restart
 }
 procedure DoExitWin(How:Char);
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async @run -hide %ComSpec% /c shutdown -'+How+' -t 15');
  r:=eval('@system @async _Crw_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @menu run FormCrwDaq.ActionFileExit');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(sndClick);
 end;
 {
 Перезагрузка DAQ
 Принудительный старт при ForceStart=true
 }
 procedure DoRestartDaq(cfg:String;ForceStart:Boolean);
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async _Daq_Force_Start_='+str(ord(ForceStart)));
  r:=eval('@system @async @run '+ParamStr('ProgName')+' '+cfg);
  r:=eval('@system @async @sleep 100');
  r:=eval('@system @async @async @guard %SaveGuard');
  r:=eval('@system @async @async SaveGuard=');
  b:=voice(sndClick);
 end;
 {
 Перезагрузка DAQ, другая версия
 Принудительный старт при ForceStart=true
 }
 procedure DoReloadDaq(cfg:String;ForceStart:Boolean);
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view norm FormCrwDaq');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  if ForceStart then begin
   r:=eval('@system @async @run '+ParamStr('ProgName')+' '+cfg);
   r:=eval('@system @async @sleep 100');
   r:=eval('@system @async @async @view norm FormCrwDaq');
   r:=eval('@system @async @async @view norm FormDaqControlDialog');
   r:=eval('@system @async @async @menu run FormDaqControlDialog.ActionDaqStart');
  end;
  r:=eval('@system @async @async @guard %SaveGuard');
  r:=eval('@system @async @async SaveGuard=');
  b:=voice(sndClick);
 end;
 {
 Инициализирует тег и проверяет
 }
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 if runcount=1 then begin
  errors:=0;
  errcode:=registererr(progname);
  s:=''; WinName:='';
  InitTag(tagEditState, 'EditState', 1);
  InitTag(tagEdit1,     'EditTag#1', 1);
  InitTag(tagEdit2,     'EditTag#2', 2);
  InitTag(tagEdit3,     'EditTag#3', 3);
  writeln('Start ',progname,' test.');
  writeln(LangStr('ru "Язык интерфейса: Русский" en "Interface language: English"'));
  b:=winshow(ParamStr('Console '+devname));
  b:=windraw(ParamStr('Console '+devname)+'|Top=320|Left=0|');
  if errors<>0 then b:=fixerror(errcode);
  Ok:=(errors=0);
 end else
 if isinf(runcount) then begin
  writeln('Stop ',progname,' test.');
  s:=''; WinName:='';
 end else
 if Ok then begin
  b:=isettag(tagEditState,editstate);
  if clickbutton=1 then begin
   {
   По щелчку State очистка редактирования
   }
   if IsSameText(clicksensor,'EDITSTATE') then begin
    b:=voice(sndClick);
    s:=edit('');
   end;
   {
   }
   if IsSameText(clicksensor,'EDITINP') then begin
    b:=voice(sndClick);
    write(edit('?inp count'));
    for i:=0 to val(edit('?inp count'))-1 do write(' ',edit('?inp '+str(i)));
    writeln;
   end;
   {
   Распечатать содержимое буфера запроса на редактирование
   }
   if IsSameText(clicksensor,'EDITASK') then begin
    b:=voice(sndClick);
    write(edit('?ask count'));
    for i:=0 to val(edit('?ask count'))-1 do write(' ',edit('?ask '+str(i)));
    writeln;
   end;
   {
   Распечатать содержимое буфера результата редактирования
   }
   if IsSameText(clicksensor,'EDITANS') then begin
    b:=voice(sndClick);
    write(edit('?ans count'));
    for i:=0 to val(edit('?ans count'))-1 do write(' ',edit('?ans '+str(i)));
    writeln;
   end;
   {
   Инициировать диалог - предупреждение
   }
   if IsSameText(clicksensor,'WARNING') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo Warning.');
     if pos('?',edit('(Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')Warning W'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - Да/Нет
   }
   if IsSameText(clicksensor,'YESNO') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo YesNo.');
     if pos('?',edit('(Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')YesNo YN'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - Да/Нет/Отмена
   }
   if IsSameText(clicksensor,'YESNOCANCEL') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo YesNoCancel.');
     if pos('?',edit('(Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')YesNoCancel YNC'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - информацию
   }
   if IsSameText(clicksensor,'INFORMATION') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo Information.');
     if pos('?',edit('(Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')Information INF'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - ошибку
   }
   if IsSameText(clicksensor,'ERROR') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo Error.');
     if pos('?',edit('(Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')Error ERR'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - меню выбора
   }
   if IsSameText(clicksensor,'MENULIST') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo MenuList.');
     if pos('?',edit('(Caption')
               +edit(' Title')
               +edit(' Item number 1') + edit('>@echo Selected num 1')
               +edit(' Item number 2') + edit('>@echo Selected num 2')
               +edit(' Item number 3') + edit('>@echo Selected num 3')
               +edit('@set Panel.Font   Name:PT_Mono\Size:12\Color:Maroon\Style:[Bold]')
               +edit('@set ListBox.Font Name:PT_Mono\Size:24\Color:Navy\Style:[Bold]')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Width 300')+edit('@set Form.Height 230')
               //+edit('@set Form.Width  40 relative Desktop')+edit('@set Form.Height 50 relative Screen')
               //+edit('@set Form.Width  50 relative '+ClickParams('Window'))+edit('@set Form.Height 50 relative '+ClickParams('Window'))
               +edit(')MenuList MENU 2'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - выбор подмножества из списка
   }
   if IsSameText(clicksensor,'SELECTIONLIST') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo SelectionList.');
     if pos('?',edit('(Caption')
               +edit(' Title')
               +edit(' Item number 1')
               +edit(' Item number 2')
               +edit(' Item number 3')
               +edit(' Item number 4')
               +edit(' Item number 5')
               +edit('@set Panel.Font   Name:PT_Mono\Size:12\Color:Green\Style:[Bold]')
               +edit('@set ListBox.Font Name:PT_Mono\Size:14\Color:Magenta\Style:[Bold]')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               //+edit('@set Form.Width 300')+edit('@set Form.Height 220')
               //+edit('@set Form.Width  40 relative Screen')+edit('@set Form.Height 50 relative Desktop')
               //+edit('@set Form.Width  40 relative *::FormCrwDaq')+edit('@set Form.Height 50 relative TFormCrwDaq::*')
               +edit(')SelectionList SEL 0 5'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - редактор текста
   }
   if IsSameText(clicksensor,'TEXTEDIT') then begin
    pl:=Val(ExtractWord(1,ClickParams('Bounds')));  // sensor left
    pt:=Val(ExtractWord(2,ClickParams('Bounds')));  // sensor top
    pr:=Val(ExtractWord(3,ClickParams('Bounds')));  // sensor right
    pb:=Val(ExtractWord(4,ClickParams('Bounds')));  // sensor bottom
    WinName:=ClickParams('Window');                 // window name
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo TextEdit.');
     if pos('?',edit('(Caption')
               +edit(' Title')
               +edit(' Item 1')
               +edit(' Item 2')
               +edit(' Item 3')
               +edit('@set Editor.Font Name:PT_Mono\Size:14\Color:Navy\Style:[Bold]')
               +edit('@set Form.Left '+Str(pl)+' relative '+WinName+' PaintBox')
               +edit('@set Form.Top  '+Str(pb)+' relative '+WinName+' PaintBox')
               +edit(')TextEdit TXT'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - редактор таблицы
   }
   if IsSameText(clicksensor,'STRINGGRIDEDIT') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo StringGridEdit.');
     if pos('?',edit('(Отредактируйте')
               +edit(' Row/Col | Col#1 | Col#2 | Col#3')
               +edit(' Row#1   | 11    | 12    | 13')
               +edit(' Row#2   | 21    | 22    | 23')
               +edit(' Row#3   | 31    | 32    | 33')
               +edit(' Row#4   | 41    | 42    | 43')
               +edit(' Row#5   | 51    | 52    | 53')
               +edit(' A Very Long Row   | A Very Long Variable    | X | Y')
               +edit('@set StringGrid.Font Name:PT_Mono\Size:14\Color:Navy\Style:[Bold]')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')StringGridEdit STR'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - выбор файлов
   }
   if IsSameText(clicksensor,'FILEOPENDIALOG') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo FileOpenDialog.');
     if pos('?',edit('(Please open file(s)')
               +edit(' c:\daq\*.cfg')
               +edit(' Text files (*.txt)|*.txt|')
               +edit(' Config files (*.cfg)|*.cfg|')
               +edit(' Pascal files (*.pas)|*.pas|')
               +edit(' All files (*.*)|*.*|')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')FileOpenDialog FOPEN'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Инициировать диалог - выбор каталогов
   }
   if IsSameText(clicksensor,'SELECTDIRECTORYDIALOG') then begin
    b:=voice(sndClick);
    if editstate=0 then begin
     writeln('Demo FileOpenDialog.');
     if pos('?',edit('('+LangStr('ru "Выбор каталога" en "Please Select Directory"'))
               +edit(' '+ParamStr('DaqConfigPath'))
               +edit(' sdAllowCreate, sdPerformCreate, sdPrompt')
               +edit('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox')
               +edit(')SelectDirectoryDialog SELDIR'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Демонстрация возможностей системного калькулятора
   }
   if IsSameText(clicksensor,'MainMenu')   then DoMainMenu;
   if IsSameText(clicksensor,'ToolBar')    then DoToolBar;
   if IsSameText(clicksensor,'StatusBar')  then DoStatusBar;
   if IsSameText(clicksensor,'DaqSystem')  then DoDaqSystem;
   if IsSameText(clicksensor,'ExitDaq')    then DoExitDaq;
   if IsSameText(clicksensor,'ExitCrw')    then DoExitCrw;
   if IsSameText(clicksensor,'LogoutWin')  then DoExitWin('l');
   if IsSameText(clicksensor,'HaltWin')    then DoExitWin('s');
   if IsSameText(clicksensor,'RestartWin') then DoExitWin('r');
   if IsSameText(clicksensor,'RestartDaq') then DoRestartDaq(ParamStr('DaqConfigFile'),true);
  end;
  {
  ******************************************************************
  Пример ввода тегов.
  При нажатии тега инициируем диалог ввода вызовом StartEditTag.
  Потом дожидаемся editstate=1 и берем результат через CheckEditTag.
  ******************************************************************
  }
  if clickbutton=1 then begin
   if clicktag=tagEdit1 then StartEditTag(tagEdit1,'Редактирование','Тег номер 1');
   if clicktag=tagEdit2 then StartEditTag(tagEdit2,'Редактирование','Тег номер 2');
   if clicktag=tagEdit3 then StartEditTag(tagEdit3,'Редактирование','Тег номер 3');
  end;
  if editstate=1 then begin
   CheckEditTag(tagEdit1);
   CheckEditTag(tagEdit2);
   CheckEditTag(tagEdit3);
  end;
  {
  *******************************************************************
  Обнаружив editstate=1, можно при помощи edit('?ans n') получить
  доступ к результату редактирования. Нулевой строкой всегда идет
  NAME=RESULT, где NAME-имя которое было задано при инициировании
  редактирования, RESULT-результат диалога, то есть одна из констант
   1=Ok
   2=Cancel
   6=Yes
   7=No
  Далее идут строки с дополнительной информацией, если она есть.
  MenuList       - edit('?ans 1') = номер выбранного пункта
  SelectionList  - edit('?ans n') = строки списка номеров выбранных пунктов
  TextEdit       - edit('?ans n') = строки отредактированного текста
  FileOpenDialog - edit('?ans n') = строки списка имен файлов
  Общее число строк (включая нулевую) можно получить по edit('?ans count').
  *******************************************************************
  }
  if editstate=1 then begin
   writeln('Stop edit.');
   writeln('Editing results are:');
   for i:=0 to val(edit('?ans count'))-1 do writeln(edit('?ans '+str(i)));
   if IsSameText(edit('?ans 0'),'FOPEN=1') then begin
    s:=edit('?ans 1');
    if FileExists(s) then
    if IsSameText(ExtractFileExt(s),'.cfg') then DoReloadDaq(s,true);
   end;
   if IsSameText(edit('?ans 0'),'SELDIR=1') then begin
    s:=edit('?ans 1');
    writeln('Select Directory: '+s);
   end;
   if IsSameText(edit('?ans 0'),'MENU=1') then begin
    s:=Trim(edit('?cmd '+edit('?ans 1')));
    if (Pos('@',s)=1) then writeln('User command: '+s);
   end;
   s:=edit('');
   writeln('maxavail=',maxavail:1);
  end;
  {
  *******************************************************************
  Если в программе уже открыт какой-либо модальный диалог, то попытка
  инициировать диалог даст ошибку. При этом editstate=8.
  При обнаружении ошибки надо сделать сброс, вызвав edit('').
  *******************************************************************
  } 
  if editstate=8 then begin
   writeln('Error detected when try open dialog!');
   s:=edit('');
  end;
 {
 *******************************************************************
 Отладочные фрагменты
 *******************************************************************
 }
{writeln('RunCount=',RunCount:7:0);}
{writeln('maxavail=',maxavail:1);}
{
  if round(getticks) mod 120 = 0 then begin
    b:=voice(sndClick);
    s:=edit('(Demo warning 1');
    s:=edit(' Demo warning 2');
    s:=edit(' Demo warning 3');
    s:=edit(')Warning');
  end;
}
 end;
end.
